import { INetData } from './../../libs/tc/interface/INetData';
import { PetAdopteData } from './../../libs/tw/data/pet/PetAdopteData';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { ABNetManager } from '../../libs/tc/manager/ABNetManager';
/**
 * 领养界面
 */
export default class AdoptePanel extends Panel {
    public adopteBtn: eui.Button;
    private nameTxt: eui.EditableText;
    public get skinKey() { return 'Adopte' }
    public get groupName() { return 'adopte_panel' }
    constructor() {
        super();
    }

    private init(): void {
        this.updateData();
    }

    start() {
        this.percentHeight = 100;
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.init();
    }

    public updateData(): void {

    }

    /**
     * 领养（取名）
     */
    private onClick_adopte(): void {
        if (this.nameTxt.text == '输入昵称' && this.nameTxt.textColor == 0x8FD6FC) {
            //必须自己取个名
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["请先为您的宠物取个名字吧！"], false);
            return;
        }
        var regStr = /^[\u4E00-\u9FA5A-Za-z0-9]+$/;
        if (!regStr.test(this.nameTxt.text)) {
            //只能中文、英文加数字
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["不能包含特殊字符"], false);
            return;
        }
        if (this.nameTxt.text.length > 8) {
            //最多只能8个字符
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["名字最长只能8个字"], false);
            return;
        }

        this.wordscheck((s) => {
            if (!s) {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["网络异常请稍后再试"], false);
                return
            }
            if (!DataManager.ins.getData("wordscheck").data.pass) {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["包含敏感词汇"], false);
                return
            }

            NetManager.ins.petAdopte(this.adopte_Back.bind(this), DataManager.ins.petIndexData.activityId, this.nameTxt.text);
        }, this.nameTxt.text)

    }

    private adopte_Back(success: boolean): void {
        if (!success) {
            return;
        }

        // var paData:PetAdopteData = DataManager.ins.petAdopteData;
        // if(paData.type != 2){
        //     PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["哎呀！名字重复了，换个更靓的吧！"], false);
        //     return;
        // }

        this.hidePanel();
        NetManager.ins.getPetInfo(() => {
            GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);
            //进入游戏场景
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE, true);
            // GDispatcher.dispatchEvent('PlayGuide');
            //领养抽插件，新用户奖励
            // NetManager.ins.doJoinPlugDraw((success: boolean) => {
            //     if (!success) {
            //         return;
            //     }
            //     //查询插件抽奖结果
            //     NetManager.ins.getPlugOrderStatus((success: boolean) => {
            //         if (!success) {
            //             return;
            //         }
            //         if (DataManager.ins.getPlugOrderStatusData.result == 2) {//中奖了，加积分(金币),固定+200积分,前端写死
            //             DataManager.ins.petIndexData.update({ credits: DataManager.ins.petIndexData.credits + 200 });
            //             GDispatcher.dispatchEvent('refreshCredits');//发事件，更新主场景上的积分(金币)数量
            //         }
            //     }, DataManager.ins.doJoinPlugDrawData.orderId, this.pollingCheck.bind(this), 10);

            // }, window['newUserPlugID'] ? window['newUserPlugID'] : 0);
        }, DataManager.ins.petIndexData.activityId);
    }

    onFocusIn(): void {
        if (this.nameTxt.text == '输入昵称' && this.nameTxt.textColor == 0x8FD6FC) {
            this.nameTxt.text = '';
            this.nameTxt.textColor = 0xFFFFFF;
        }
    }

    onFocusOut(): void {
        if (this.nameTxt.text == '') {
            this.nameTxt.text = '输入昵称';
            this.nameTxt.textColor = 0x8FD6FC;
        }
    }

    initEvents(): void {
        this.adopteBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_adopte, this);
        this.nameTxt.addEventListener(egret.TouchEvent.FOCUS_IN, this.onFocusIn, this);
        this.nameTxt.addEventListener(egret.TouchEvent.FOCUS_OUT, this.onFocusOut, this);
        GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);
    }

    removeEvents() {
        this.adopteBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_adopte, this);
        this.nameTxt.removeEventListener(egret.TouchEvent.FOCUS_IN, this.onFocusIn, this);
        this.nameTxt.removeEventListener(egret.TouchEvent.FOCUS_OUT, this.onFocusOut, this);
    }

    private onError(net: any, code: any): void {
        var msg: string;
        var msgArr: any = window['errorMessage'];
        if (!isNaN(code)) {
            msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';

        } else {
            msg = code;
        }

        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
    }

    private wordscheck(callback: Function, words: string) {
        const net: INetData = {
            name: 'wordscheck',
            uri: '/senstiveword/wordscheck',
            type: 'get',
            dataType: 'json',
            param: {
                words: words
            },
            callback: callback,
            hideMsg: true
        };
        NetManager.ins.send(net);
    }

    //轮询
    private pollingCheck(data: any): boolean {
        return data.result == 0;
    }
}