import { SignInScene } from './signInPanel/SignInSceneSkin';
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import Msg from "./alert/Msg";
import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import Loading from "./loading/Loading";
import RulePanel from "./rulePanel/RulePanel";
import ThemeAdapter from "./ThemeAdapter";
import { ModuleTypes } from "./types/sceneTypes";
import { getResPath } from "./utils";
import layers from "./views/layers";
import MainScene from './mainScene/MainScene';
import MyGoldCoinPanel from "./myGoldCoinPanel/MyGoldCoinPanel";
import EarnGoldCoinPanel from "./earnGoldCoinPanel/EarnGoldCoinPanel";
import TourPanel from "./tourPanel/TourPanel";
import { PetIndexData } from "../libs/tw/data/pet/PetIndexData";
import AdoptePanel from "./adoptePanel/AdoptePanel";
import MsgPanel from "./msgPanel/MsgPanel";
import AlbumPanel from "./albumPanel/AlbumPanel";
import RewardPanel from "./rewardPanel/RewardPanel";
import { PropPanel } from './propPanel/PropPanel';
import AlbumInfoPanel from './albumPanel/AlbumInfoPanel';
import SharePanel from './sharePanel/SharePanel';
import { Buried } from '../libs/tw/util/Buried';
import GuidePanel from './guidePanel/GuidePanel';
import { GuidePrizePanel } from './guidePrizePanel/GuidePrizePanel';
import { ExMainScene } from './mainScene/ExMainScene';
import { SignInPanel } from './signInPanel/SignInPanelSkin';
import { SignInPrizePanel } from './signInPanel/SignInPrziePanelSkin';
import { ExtraPrizePanel } from './extraPrizePanel/ExtraPrizePanel';
import UpPrizePanel from './upPrizePanel/upPrizePanel';
import UpNoPrizePanel from './upNoPrizePanel/UpNoPrizePanel';

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();
        // alert(1)

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        // egret.lifecycle.onPause = () => {
        //     egret.ticker.pause();
        // }

        // egret.lifecycle.onResume = () => {
        //     egret.ticker.resume();
        // }

        //inject the custom material parser
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        DataManager.ins.petIndexData = new PetIndexData();
        DataManager.ins.petIndexData.update(window['CFG']);
        // NetManager.ins.getCredits(()=>{});

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        Buried.init();

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        PanelCtrl.instance.registerPanelClass(ModuleTypes.ADOPTE_PANEL, AdoptePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.EXTRA_PRIZE_PANEL, ExtraPrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, MsgPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.SIGN_IN_PANEL, SignInPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.SIGN_IN_PRIZE_PANEL, SignInPrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.GUIDE_PRIZE_PANEL, GuidePrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.UPNO_PRIZE_PANEL, UpNoPrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.UPPRIZE_PANEL, UpPrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.EARN_GOLD_COIN_PANEL, EarnGoldCoinPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.GUIDE_PANEL, GuidePanel);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.MAIN_SCENE, ExMainScene);

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        // RES.loadGroup("msg", 10);
    }

    private async loadResource() {
        try {
            // const loadingView = new LoadingUI();
            // this.stage.addChild(loadingView);
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();

            // await RES.loadGroup("msg", 10);
            // this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    private textfield: egret.TextField;
    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        //获取签到信息
        NetManager.ins.getSignInfo(() => {
            NetManager.ins.getPetInfo(() => {
                this.getGameRes();
            }, DataManager.ins.petIndexData.activityId);
        }, window['signActivityId']);

    }

    //加载游戏中的资源
    private async getGameRes(){
        //还没有宠物，先播放介绍文字
        if (!DataManager.ins.petHomeInfoData.petId) {
            await RES.loadGroup('adopte_panel');
            await RES.getResAsync('adopteBg_jpg');
            PanelCtrl.instance.show(ModuleTypes.ADOPTE_PANEL);
            await RES.loadGroup('guide_component');
        } else {//已经有宠物了，进入游戏场景
            await RES.loadGroup('main_scene');
            await RES.getResAsync('bgday_jpg');
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
        }

        //加载组
        await RES.loadGroup('signIn_prize_panel');
        await RES.loadGroup('signIn_panel');
        await RES.loadGroup('extra_prize_panel');
        await RES.loadGroup('upPrize_panel');
        await RES.loadGroup('upNoPrize_panel');
        await RES.loadGroup('earnGold_panel');
        await RES.loadGroup('guide_panel');
        //加载图片
        await RES.getResAsync('gamerule_jpg');
        await RES.getResAsync('guideBg_jpg');

    }
}

window['Main'] = Main;