"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var Scene_1 = require("../views/Scene");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var TouchEvent = egret.TouchEvent;
var PlayScene = (function (_super) {
    __extends(PlayScene, _super);
    function PlayScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 游戏参数
        _this.userCredits = 0;
        _this.unitNum = 10;
        _this.currCostCredits = 0;
        _this.lightCount = 0;
        _this.lightRate = 30;
        _this.isLight = false;
        _this.multiplesArr = [];
        _this.angleArr = [];
        _this.ranArr = [];
        _this.coinsArr = [];
        _this.gravity = 4.5;
        _this.timeOnEnterFrame = 0;
        _this.currEarnCredits = 0;
        return _this;
    }
    PlayScene.prototype.initEvents = function () {
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_startBtn, this);
        this.reduceBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_reduceBtn, this);
        this.addBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_addBtn, this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_ruleBtn, this);
    };
    PlayScene.prototype.removeEvents = function () {
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_startBtn, this);
        this.reduceBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_reduceBtn, this);
        this.addBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_addBtn, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_ruleBtn, this);
    };
    PlayScene.prototype.start = function () {
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        this.circleLight1.$touchEnabled = false;
        this.circleLight2.$touchEnabled = false;
        this.finger.$touchEnabled = false;
        this.sideLightL.visible = false;
        this.userCredits = DataManager_1.DataManager.ins.getInfoData ? DataManager_1.DataManager.ins.getInfoData.credits : 0;
        this.unitName = DataManager_1.DataManager.ins.getCreditsData ? "" + DataManager_1.DataManager.ins.getCreditsData.unitName : "\u79EF\u5206";
        if (this.userCredits < 10) {
            this.currCostCredits = 0;
        }
        else if (this.userCredits <= 200) {
            this.currCostCredits = 10;
        }
        else if (this.userCredits <= 500) {
            this.currCostCredits = 20;
        }
        else if (this.userCredits <= 1000) {
            this.currCostCredits = 30;
        }
        else if (this.userCredits <= 5000) {
            this.currCostCredits = 50;
        }
        else if (this.userCredits <= 10000) {
            this.currCostCredits = 100;
        }
        else if (this.userCredits > 10000) {
            this.currCostCredits = 200;
        }
        this.costTxt.text = "" + this.currCostCredits;
        this.unitTxt.text = "\u6295\u5165" + this.unitName;
        this.userCreditsUnitName.text = "\u603B" + this.unitName;
        this.userCreditsNum.text = "" + this.userCredits;
        var fingerTw = egret.Tween.get(this.finger, { loop: true });
        fingerTw.to({ scaleX: 0.9, scaleY: 0.9 }, 500).to({ scaleX: 1, scaleY: 1 }, 500);
        this.WheelBg['realRotation'] = 0;
        console.log(this.WheelBg);
        // 按从小到大排序
        this.multiplesArr = [0, 0.2, 0.4, 0.5, 0.8, 1.0, 1.1, 1.2, 1.4, 1.5, 2];
        var unitAngle = 360 / 16;
        this.angleArr = [13 * unitAngle, 11 * unitAngle, 0, 5 * unitAngle, 8 * unitAngle, 14 * unitAngle, 12 * unitAngle, 6 * unitAngle, 10 * unitAngle, 3 * unitAngle, 2 * unitAngle];
        this.ranArr = [1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11, 1 / 11];
    };
    PlayScene.prototype.onLoad = function (event) {
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    PlayScene.prototype.onEnterFrame = function (e) {
        var scope = this;
        scope.lightCount++;
        if (scope.lightCount % scope.lightRate == 0) {
            scope.isLight = !scope.isLight;
        }
        scope.circleLight2.visible = scope.isLight;
        if (scope.coinsArr.length > 0) {
            for (var c = scope.coinsArr.length - 1; c >= 0; c--) {
                scope.coinsArr[c].x += scope.coinsArr[c].dirX * scope.coinsArr[c].vx;
                scope.coinsArr[c].y -= scope.coinsArr[c].vy;
                scope.coinsArr[c].vy -= scope.gravity;
            }
        }
    };
    // 开始游戏
    PlayScene.prototype.onClick_startBtn = function (e) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        if (this.userCredits < 10) {
            var data = { msg: this.unitName + "\u4E0D\u8DB3\u6700\u5C0F\u6295\u503C10" + this.unitName + "\u5FEB\u53BB\u8D5A\u53D6" + this.unitName + "\u5427", type: 'creditsOut' };
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, data);
            return;
        }
        var scope = this;
        var wbg = egret.Tween.get(this.WheelBg, { onChange: scope.onWbgRotationChange.bind(scope) });
        scope.removeChild(scope.goAni);
        var func;
        wbg.to({ realRotation: (scope.WheelBg['realRotation'] + 3600) }, 2000, egret.Ease.quartIn).call(func = function () {
            var _rotation = scope.WheelBg['realRotation'] + 360;
            scope.wbgloop = egret.Tween.get(scope.WheelBg, { onChange: scope.onWbgRotationChange.bind(scope), loop: true });
            scope.wbgloop.to({ realRotation: _rotation }, 300).call(function () {
                _rotation = scope.WheelBg['realRotation'] + 360;
            });
        });
        this.finger.visible = false;
        this.lightRate = 5;
        this.sideLightL.visible = true;
        this.buttonEnable(false);
        this.startBtn.currentState = 'wating';
        this.doStart(this.doStartResult.bind(this), false, this.currCostCredits, 1);
    };
    // 开始游戏接口
    PlayScene.prototype.doStart = function (callback, isAgain, credits, customizedType) {
        var _this = this;
        if (isAgain === void 0) { isAgain = false; }
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager_1.NetManager.ins.doStart(function (success) {
            if (success) {
                _this.getStartStatus(callback, customizedType);
            }
            else {
                callback(success);
            }
        }, isAgain, credits, customizedType);
    };
    // 查询开始状态
    PlayScene.prototype.getStartStatus = function (callback, customizedType) {
        var param = {
            ticketId: DataManager_1.DataManager.ins.doStartData.ticketId
        };
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: 'getStartStatus',
            uri: '/ngapi/getStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: 5,
            pollingCheck: function () { return DataManager_1.DataManager.ins.getData('getStartStatus').code != 1; }
        };
        NetManager_1.NetManager.ins.send(net);
    };
    // 开始的回调
    PlayScene.prototype.doStartResult = function (success) {
        var _this = this;
        var scope = this;
        if (!success) {
            this.defaultErr();
            return;
        }
        var upperCreditsLimit = DataManager_1.DataManager.ins.getData('getStartStatus').upperCreditsLimit ? DataManager_1.DataManager.ins.getData('getStartStatus').upperCreditsLimit : scope.currCostCredits;
        // 取得的返回最大倍数
        var maxMultiple = upperCreditsLimit / scope.currCostCredits;
        console.log("\u6700\u5927\u500D\u6570:" + maxMultiple);
        // 改变数组
        var newMultiplesArr = [];
        for (var m = 0; m < scope.multiplesArr.length; m++) {
            if (scope.multiplesArr[m] < maxMultiple) {
                newMultiplesArr.push(scope.multiplesArr[m]);
            }
        }
        // 更新用户积分文案
        scope.userCreditsNum.text = "" + (DataManager_1.DataManager.ins.getInfoData ? DataManager_1.DataManager.ins.getInfoData.credits : scope.userCredits);
        // 拿到倍数
        var newAngleArr = [];
        var newRanArr = [];
        var arr = [];
        for (var i_1 = 0; i_1 < newMultiplesArr.length; i_1++) {
            newAngleArr.push(scope.angleArr[i_1]);
            newRanArr.push(scope.ranArr[i_1]);
            var num = Math.round(120 * newRanArr[i_1]);
            var a = (new Array(num))["fill"](newAngleArr[i_1]);
            arr = arr.concat(a);
        }
        var randomT = function (e, n) {
            return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
        };
        var targetAngle = randomT(arr);
        var i = scope.angleArr.indexOf(targetAngle);
        var multiple = scope.multiplesArr[i];
        this.multiple = multiple;
        console.log("\u968F\u673A\u500D\u6570:" + multiple);
        var timeout = setTimeout(function () {
            clearTimeout(timeout);
            egret.Tween.removeTweens(scope.WheelBg);
            var tw = egret.Tween.get(scope.WheelBg, { onChange: scope.onWbgRotationChange.bind(scope) });
            var _rotation = Math.random() > 0.5 ? scope.WheelBg['realRotation'] + (360 - scope.WheelBg['realRotation'] % 360) + targetAngle + 1440 + Math.random() * 8 : scope.WheelBg['realRotation'] + (360 - scope.WheelBg['realRotation'] % 360) + targetAngle + 1440 - Math.random() * 8;
            tw.to({ realRotation: _rotation }, 8000, egret.Ease.quartOut).call(function () {
                scope.startBtn.currentState = 'up';
                scope.buttonEnable(false);
                scope.sideLightL.visible = false;
                scope.lightRate = 30;
                scope.coinsFall(true);
            });
        }, 1000);
        // 延时提交分数
        var timeout2 = setTimeout(function () {
            _this.gameSubmitData(_this.gameSubmitResult.bind(_this), _this.currCostCredits * multiple, false, 1);
        }, 500);
    };
    PlayScene.prototype.gameSubmitResult = function () {
        NetManager_1.NetManager.ins.getInfo(function () { });
        console.log('提交成功');
    };
    /**
     * 提交游戏成绩
     * @param callback
     * @param score 得分
     * @param allDynamics 防作弊数据
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机
     */
    PlayScene.prototype.gameSubmitData = function (callback, score, checkScore, customizedType) {
        var _this = this;
        NetManager_1.NetManager.ins.gameSubmit(function (success) {
            if (success) {
                _this.getSubmitResult(callback, DataManager_1.DataManager.ins.gameSubmitData.orderId);
            }
            else {
                callback(success);
            }
        }, DataManager_1.DataManager.ins.doStartData.ticketId, score, '[]', DataManager_1.DataManager.ins.doStartData.submitToken, '', checkScore, customizedType);
    };
    /**
     * 查询提交结果
     * @param callback
     * @param orderId
     */
    PlayScene.prototype.getSubmitResult = function (callback, orderId) {
        NetManager_1.NetManager.ins.getSubmitResult(callback, orderId, function () {
            return DataManager_1.DataManager.ins.gameGetSubmitResultData.flag;
        });
    };
    // 默认出错——转到0后弹错误窗
    PlayScene.prototype.defaultErr = function () {
        var _this = this;
        var timeout = setTimeout(function () {
            clearTimeout(timeout);
            egret.Tween.removeTweens(_this.WheelBg);
            var tw = egret.Tween.get(_this.WheelBg, { onChange: _this.onWbgRotationChange.bind(_this) });
            _this.multiple = 0;
            var _rotation = _this.WheelBg['realRotation'] + (360 - _this.WheelBg['realRotation'] % 360) + 360 * 13 / 16 + 1440;
            tw.to({ realRotation: _rotation }, 8000, egret.Ease.quartOut).call(function () {
                _this.startBtn.currentState = 'up';
                _this.buttonEnable(true);
                _this.sideLightL.visible = false;
                _this.lightRate = 30;
                _this.coinsFall(false);
            });
        }, 2000);
    };
    PlayScene.prototype.onWbgRotationChange = function () {
        this.WheelBg.rotation = this.WheelBg['realRotation'];
    };
    // 减号
    PlayScene.prototype.onClick_reduceBtn = function (e) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        if ((this.currCostCredits - this.unitNum) > 0 && (this.userCredits - this.unitNum) > 0) {
            this.currCostCredits -= this.unitNum;
        }
        this.costTxt.text = "" + this.currCostCredits;
    };
    // 加号
    PlayScene.prototype.onClick_addBtn = function (e) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        if ((this.currCostCredits + this.unitNum) <= this.userCredits && this.currCostCredits < 500) {
            this.currCostCredits += this.unitNum;
        }
        this.costTxt.text = "" + this.currCostCredits;
    };
    // 规则按钮
    PlayScene.prototype.onClick_ruleBtn = function (e) {
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RULE_PANEL);
    };
    PlayScene.prototype.childrenCreated = function () {
        _super.prototype.childrenCreated.call(this);
        this.ayncLoad2Mc("goBtn_json");
        this.ayncLoad2Mc("coin_json");
    };
    PlayScene.prototype.ayncLoad2Mc = function (resname) {
        var scope = this;
        RES.getResAsync(resname, function (data, key) {
            if (key == "coin_json") {
                scope.ayncLoad2Mc("coin_png");
            }
            else if (key == "coin_png") {
                for (var i = 0; i < 100; i++) {
                    var data2mc = RES.getRes("coin_json");
                    var texture2mc = RES.getRes("coin_png");
                    var mcFactory = new egret.MovieClipDataFactory(data2mc, texture2mc);
                    var mc = new egret.MovieClip(mcFactory.generateMovieClipData("coin"));
                    scope.coinsArr.push(mc);
                }
            }
            else if (key == "goBtn_json") {
                scope.ayncLoad2Mc("goBtn_png");
            }
            else if (key == "goBtn_png") {
                var data2mc = RES.getRes("goBtn_json");
                var texture2mc = RES.getRes("goBtn_png");
                var mcFactory = new egret.MovieClipDataFactory(data2mc, texture2mc);
                var mc = new egret.MovieClip(mcFactory.generateMovieClipData("go"));
                mc.gotoAndPlay('light', -1);
                scope.goAni = mc;
                scope.addChild(scope.goAni);
                scope.addChild(scope.finger);
                mc.x = 279;
                mc.y = 494;
            }
        }, this);
    };
    // 金币掉落效果
    PlayScene.prototype.coinsFall = function (isSuccess) {
        var _this = this;
        var scope = this;
        var count = 0;
        var coinsFall = setInterval(function () {
            if (count < 100) {
                scope.addChild(scope.coinsArr[count]);
                scope.coinsArr[count].gotoAndPlay('rotate', -1);
                if (Math.random() > 0.5) {
                    scope.coinsArr[count].dirX = 1;
                }
                else {
                    scope.coinsArr[count].dirX = -1;
                }
                scope.coinsArr[count].vy = Math.random() * 60;
                scope.coinsArr[count].vx = Math.random() * 30;
                scope.coinsArr[count].x = _this.stage.stageWidth / 2 - scope.coinsArr[count].width / 2;
                scope.coinsArr[count].y = 500;
                count++;
                _this.addChild(_this.resulePanel);
            }
            else {
                if (!isSuccess) {
                    // 失败
                    var msg = DataManager_1.DataManager.ins.doStartData ? DataManager_1.DataManager.ins.doStartData.message : "\u7F51\u7EDC\u51FA\u4E86\u70B9\u5C0F\u95EE\u9898\u8BF7\u9000\u51FA\u540E\u91CD\u8BD5";
                    var data = { msg: msg, type: 'err' };
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, data);
                }
                clearInterval(coinsFall);
            }
        }, 10);
        scope.showResultPanel();
    };
    PlayScene.prototype.showResultPanel = function () {
        var scope = this;
        scope.currEarnCredits = scope.currCostCredits * scope.multiple;
        var resultPanelTw = egret.Tween.get(scope.resulePanel);
        resultPanelTw.to({ scaleX: 1, scaleY: 1 }, 300).wait(2000).call(function () {
            scope.resulePanel.scaleX = 0;
            scope.resulePanel.scaleY = 0;
            scope.buttonEnable(true);
            scope.addChild(scope.goAni);
        });
        this.resulePanel['credits'].text = "0";
        var credits = { num: 0 };
        credits.num = Number(this.resulePanel['credits'].text);
        var creditTw = egret.Tween.get(credits, { onChange: onCreditsChange });
        creditTw.to({ num: this.currEarnCredits }, 1000);
        function onCreditsChange() {
            var c = Math.floor(credits.num);
            scope.resulePanel['credits'].text = "" + c;
        }
    };
    // 按钮状态
    PlayScene.prototype.buttonEnable = function (enabled) {
        this.startBtn.enabled = enabled;
        this.addBtn.enabled = enabled;
        this.reduceBtn.enabled = enabled;
        this.ruleBtn.enabled = enabled;
    };
    Object.defineProperty(PlayScene.prototype, "skinKey", {
        get: function () { return 'Play'; },
        enumerable: true,
        configurable: true
    });
    return PlayScene;
}(Scene_1.default));
exports.default = PlayScene;
__reflect(PlayScene.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/playScene/PlayScene\".PlayScene");
//# sourceMappingURL=PlayScene.js.map