import { GamePlayModel } from "../../libs/tw/model/game/GamePlayModel";
import Scene from "../views/Scene";
import Box from "./Box";
import BoxListCtrl from "./BoxListCtrl";
import LayerTypes from "./data/LayerTypes";
import debug from "./debug";
import Guide from "./Guide";
import GuideCtrl from "./GuideCtrl";
import Monkey from "./Monkey";
import Net from "./Net";
import BoxOpenState from "./view/BoxOpenState";

const { TouchEvent } = egret;
export default class StartScene extends Scene {
    private _net: Net;
    private _monkey: Monkey;
    private _boxListCtrl: BoxListCtrl;
    private _guideView: Guide;
    private _guideCtrl: GuideCtrl;
    static NET_RANGE = 200;
    private _debug: debug;
    async start(data?) {
        const t1 = Date.now() - __t0__;
        console.log(`startScene添加到stage:${t1 / 1000}s`)

        const picData: any = await this.getBg();
        const pic = new egret.Bitmap(picData);
        egret.Tween.get(pic).set({ alpha: 0 }).to({ alpha: 1 }, 500);
        this.getLayer(LayerTypes.bg).addChild(pic);
        const t2 = Date.now() - __t0__;
        console.log(`首屏(背景显示)时间:${t2 / 1000}s`);

        this._boxListCtrl = new BoxListCtrl(this.getLayer(LayerTypes.box));
        await this._boxListCtrl.createFirstBox();

        this._boxListCtrl.resume();
        const t3 = Date.now() - __t0__;
        console.log(`关键利益点时间:${t3 / 1000}s`);

        const monkey = new Monkey();
        this.getLayer(LayerTypes.monkey).addChild(monkey);
        monkey.addEventListener('pointUpdate', this.onPointUpdate, this)
        this._monkey = monkey;

        this._guideView = new Guide(this.getLayer(LayerTypes.guide));
        this._guideCtrl = new GuideCtrl(this);

        const net = new Net();
        this.getLayer(LayerTypes.net).addChild(net);
        this._net = net;

        if (__debug__) {
            this._debug = new debug(this.getLayer(LayerTypes.top));
        }

        const model = new GamePlayModel();
        model.update();
        // box.touchEnabled = true;
        // box.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
        //     NetManager.ins.getInfo(() => {
        //         model.doStart(() => {
        //             model.submit(() => { }, box.boxData.award)
        //         }, false);
        //     });

        //     PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

        // }, this);
    }

    addTouchEvent() {
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    removeTouchEvent() {
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    private _catchedBox: Box;
    private _cathchedBoxOpenState: BoxOpenState;
    async onTouch() {
        this._net.doAction();
        const catchedBoxs = this._boxListCtrl.boxs.filter(
            box => Math.abs(box.y - Box.MIDDLE_Y) < StartScene.NET_RANGE);
        const catchedBox = catchedBoxs[0];
        if (catchedBox) { //抓住了，box没有办法再过线消失
            this._boxListCtrl.pause();
            //先从boxlist中移除，使之不再受到boxlistCtrl的控制
            this._boxListCtrl.removeBoxFromList(catchedBox);
            this._catchedBox = catchedBox;
            catchedBox.doThrow();
            this.addThrowTick();
        } else {//没有抓住，不需要处理，如果过网了就会自动消失。如果没有过网，下次还能抓。

        }
    }

    addThrowTick() {
        this.addEventListener(egret.Event.ENTER_FRAME, this.onThrowTick, this);
    }

    removeThrowTick() {
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onThrowTick, this);
    }

    onThrowTick() {
        this._catchedBox.onThrowTick();
        const disX = Math.abs(this._catchedBox.x - this._handX);
        const disY = Math.abs(this._catchedBox.y - this._handY);
        const dis = 100 + __monkeyHandSize__;
        if (disX < dis && disY < dis) {
            this.onCatchedByMonkey();
        } else if (this._catchedBox.vy > 0) {
            this.onNotCatchedByMonkey();
        }
    }

    private _catchedBoxByMoneky: Box;
    onCatchedByMonkey() {
        this.removeThrowTick();
        this._catchedBoxByMoneky = this._catchedBox;
        this._catchedBox = null;
        egret.Tween.get(this._catchedBoxByMoneky)
            .to({ scaleX: 1, scaleY: 1 }, 500)
            .wait(500)
            .to({ alpha: 0 }, 500).call(() => {
                this._catchedBoxByMoneky.destroy();
                this._catchedBoxByMoneky = null;
                this.boxListCtrl.resume();
            }, this);
    }

    onNotCatchedByMonkey() {
        this.removeThrowTick();
        this._cathchedBoxOpenState = new BoxOpenState(this._catchedBox.type);
        this._cathchedBoxOpenState.x = this._catchedBox.x;
        this._cathchedBoxOpenState.y = this._catchedBox.y;
        this.topLay.addChild(this._cathchedBoxOpenState);
        this._cathchedBoxOpenState.onReady = () => {
            egret.Tween.get(this._catchedBox).to({ alpha: 0 }, 500);
            this._catchedBox = null;
        }
        this._cathchedBoxOpenState.start();

        setTimeout(() => {
            this._cathchedBoxOpenState.destroy();
            this._cathchedBoxOpenState = null;
            this.boxListCtrl.resume();
        }, 1000);
    }

    private _handX: number;
    private _handY: number;
    onPointUpdate(e: egret.Event) {
        const p = e.data as egret.Point;
        this._handX = p.x + this._monkey.x;
        this._handY = p.y + this._monkey.y;
        if (this._catchedBoxByMoneky) {
            this._catchedBoxByMoneky.x = this._handX;
            this._catchedBoxByMoneky.y = this._handY;
        }
        if (this._debug) {
            this._debug.shape.x = this._handX;
            this._debug.shape.y = this._handY;
        }
    }
    async getBg() {
        let url = __bgUrl__
        return new Promise((resolve) => {
            RES.getResByUrl(url, (picData) => {
                resolve(picData)
            }, this, RES.ResourceItem.TYPE_IMAGE);
        });
    }

    protected get layerKeys() {
        return [
            LayerTypes.bg,
            LayerTypes.kids,
            LayerTypes.guide,
            LayerTypes.net,
            LayerTypes.box,
            LayerTypes.monkey,
            LayerTypes.top,

        ]
    }
    protected get skinKey() { return 'Start' }
    get guideView() { return this._guideView }
    get monkey() { return this._monkey }
    get boxListCtrl() { return this._boxListCtrl }
    get net() { return this._net }
    get topLay() { return this.getLayer(LayerTypes.top) }
}