/**
 *Created by cuiliqiang on 2018/3/12
 * 闯关游戏配置数据
 */
import { Data } from "../../Data";
import { IThroughInfoData } from "./IThroughInfoData";

export class AjaxThroughInfoData extends Data {
    /**
     * 闯关信息
     */
    public throughNum: number;

    /**
     * 闯关模式
     */
    public throughCurrent: number;

    /**
     * 关卡ID
     */
    public throughCurrentStep: number;

    /**
     * 站点位置
     */
    public throughMode: number;

    /**
     * 关卡列表
     */
    public throughInfoList: IThroughInfoData[];

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.throughCurrent = data.throughCurrent;
        this.throughMode = data.throughMode;
        this.throughNum = data.throughNum;
        this.throughCurrentStep = data.throughCurrentStep;
        this.throughInfoList = data.throughInfo;
    }
}