import { bubbleStandbyGroup, bubbleStandby, bubbleStandbyMask } from "./collisionConfig";
import createBubblePic from "./createBubblePic";
import EgretRender from "../physics/EgretRender";
import random from "./random";

let timerLeft;
let timerRight;
export const startStandbyBubblesLeft = (egretRender: EgretRender) => {
    timerLeft = setInterval(() => {
        const scale = 0.2;
        const p1 = { x: 206, y: 832 };
        const r = random(8, 10);
        const bubblePic = createBubblePic(r);
        const body = egretRender.circle(p1.x, p1.y, r, bubblePic, {
            restitution: 0,
            frictionAir: 0,
            force: { x: random(-0.005, 0.005) * scale, y: -0.02 * scale },
            collisionFilter: { group: bubbleStandbyGroup, category: bubbleStandby, mask: bubbleStandbyMask }
        });
        setTimeout(() => {
            egretRender.remove(body);
        }, 1000);
    }, 700);
}

export const startStandbyBubblesRight = (egretRender: EgretRender) => {
    timerRight = setInterval(() => {
        const scale = 0.2;
        const p2 = { x: 551, y: 832 };
        const r2 = random(8, 10);
        const bubblePic2 = createBubblePic(r2);
        const body2 = egretRender.circle(p2.x, p2.y, r2, bubblePic2, {
            restitution: 0,
            frictionAir: 0,
            force: { x: random(-0.005, 0.005) * scale, y: -0.02 * scale },
            collisionFilter: { group: bubbleStandbyGroup, category: bubbleStandby, mask: bubbleStandbyMask }
        });
        setTimeout(() => {
            egretRender.remove(body2);
        }, 1000);
    }, 700);
}

export const stopStandbyBubblesLeft = () => {
    clearInterval(timerLeft)
}
export const stopStandbyBubblesRight = () => {
    clearInterval(timerRight)
}