import BaseItem from "../../physics/BaseItem";
import MovieClip from "../../physics/movieclip/MovieClip";
import LabelType from "./LabelType";

const createGift = (scale) =>{
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const texture = RES.getRes('gift_json');
    const animation = createGiftMovieClip(texture, 0.5);//礼物纹理大概130
    const baseItem = new BaseItem(animation,LabelType.gift);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createGiftMovieClip = (spritesheet, scale)=> {
    const list = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createGift