import { Data } from "../Data";
import { IUsingPetToysData } from "./IUsingPetToysData";
import { IWanderPetData } from "./IWanderPetData";

export class GetHomeInfoData extends Data {
    /**
     * 账户额度上限
     */
    public accountBalanceLimit: number;

    /**
     * 每份待领取个数
     */
    public amountPerPiles: number;

    /**
     * 是否有新动态
     */
    public hasNewInfo: boolean;

    /**
     * 是否有待领取礼物
     */
    public hasGift: boolean;

    /**
     * 距离下一次投放道具剩余的时间（分钟）
     */
    public nextPeriodBegin: number;

    /**
     * 正在投放的道具
     */
    public usingPetToys: IUsingPetToysData[];

    /**
     * 正在来访的宠物
     */
    public wanderPet: IWanderPetData;

    /**
     * 当前粮食数
     */
    public accountBalance: number;
    
    /**
     * 待收取粮食列表   
     * [{id:1, foodNum:10}, {id:2, foodNum:20}]
     */
    public foodPiles: any;

    /**
     * 是否为新用户
     */
    public newUser:boolean;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);

        let data;
        if (result.data) {
            data = result.data;
        }
        if(data){
            this.accountBalanceLimit = data.accountBalanceLimit;
            this.amountPerPiles = data.amountPerPiles;
            this.hasNewInfo = data.hasNewInfo;
            this.hasGift = data.hasGift;
            this.nextPeriodBegin = data.nextPeriodBegin;
            this.usingPetToys = data.usingPetToys;
            this.wanderPet = data.wanderPet;
            this.accountBalance = data.accountBalance;
            this.foodPiles = data.foodPiles;
            this.newUser = data.newUser;
        }
    }
}