import { Square } from "../physics/Square";
import PlayScene from "../PlayScene";

export default (that: PlayScene, x, y, num) => {
    const picType = Math.ceil(Math.random() * 4);
    const pic = new egret.Bitmap(RES.getRes(`sq${picType}_png`));
    pic.anchorOffsetX = pic.width / 2;
    pic.anchorOffsetY = pic.height / 2;
    let block: Square = that.pool.takeOut("square");
    if (!block) {
        const sprite = new egret.Sprite();
        sprite.touchEnabled = sprite.touchChildren = false;
        //背景
        const length = pic.width;
        sprite["bg"] = pic;
        sprite.addChild(pic);
        //数字
        const txt = new egret.TextField();
        txt.width = length;
        txt.height = length;
        txt.anchorOffsetX = length / 2;
        txt.anchorOffsetY = length / 2;
        txt.size = 30;
        txt.textColor = 0xffffff;
        txt.textAlign = egret.HorizontalAlign.CENTER;
        txt.verticalAlign = egret.VerticalAlign.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        // that.view.addChild(sprite)
        block = new Square(length, sprite);
    }
    //初始化
    else {
        if (block.view["bg"]) {
            block.view.removeChild(block.view["bg"]);
            block.view["bg"] = pic;
            block.view.addChild(pic);
            block.view.addChild(block.view['txt']);
        }
    }
    block.view["bg"]['__resName__'] = `sq${picType}_png`;
    that.addChild(block.view)
    block.x = x;
    block.y = y;
    block.num = num;
    block.rotation = Math.random() * 360;
    // block.rotation = Math.random()>0.5 ? 0 : 45;
    that.blocks.push(block);
    block.ladderNums = 1;
}