import Panel from "../views/Panel";
import { ButtonType } from "../types/sceneTypes";
import SceneCtrl from '../ctrls/sceneCtrl';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import PanelCtrl from "../ctrls/panelCtrl";

export default class ToastPanel extends Panel {
   
 
   
    public backBtn:eui.Group;

    public hintLab:eui.Label;

    public startTimeLab:eui.Label;

    public nostartGroup:eui.Group;
    public nostartLb:eui.Label;

    public endHint:eui.Label;
    private mdata:any;
    public get skinKey() { return 'ToastPanel' }
    public get groupName() { return 'prize_panel'}

    public bg:eui.Image;
    private bgTexture:egret.Texture;
    start(data) {
        this.mdata = data;
        this.percentHeight = 100;

    }
    protected async preLoadRes() {

        this.bgTexture = await RES.getResAsync('noStartBg_jpg');
        return new Promise(function (resolve) {
            resolve();
        });
        
    }
    onSkinComplete() {
        super.onSkinComplete();
        this.bg.texture = this.bgTexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
       
    }

    removeEvents() {
        super.removeEvents();
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
    }

    private ontap_this():void{
        super.onTouchTap();
        return;
        if(this.mdata.btnType == ButtonType.TRY_BTN)
        {
            NetManager.ins.ajaxElementNew(function(success){
                if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }else{
                    this.show(ModuleTypes.TOAST_PANEL, {title:'获取失败',content:'请刷新重试',btnType:ButtonType.KNOW_BTN});
                }
            }.bind(this));
        }
        else
        {
            if(this.mdata.btnType != ButtonType.SHATE_BTN)
            {
                if(this.mdata && this.mdata.callBack){
                    this.mdata.callBack();
                }
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }
        }
    }

    private colseBtnClick(){
        super.onTouchTap();
        console.log("返回原入口成功");
        PanelCtrl.instance.btnDelay(this.backBtn);
        window['wx'].miniProgram.reLaunch({url: '/pages/index'});
        // window.location.href = window['firstPage'] ? window['firstPage'] : "https://activity.m.duibatest.com.cn/autoLogin/autologin?dcustom=false&redirect=https%3A%2F%2Factivity.m.duibatest.com.cn%2Fhdtool%2Findex%3Fid%3D136231944462316%26dbnewopen&uid=%7BAES%7D8TapjMBqrdodBApj82TC%2Bo%2BoxAg9bt1Iz%2BNN81AnfJMNraa%2BVc%2B4IHvNj9fYznaC&credits=100&sign=373bfed237362b2a04545e6a0c9701e8&appKey=4GgYPqYfHsJHFdBgTRCv2R1JRdrc&timestamp=1593437003744&"
    }
    private onLoad():void{
        if(this.mdata.type == 1)
        {
            this.hintLab.text = window['activityHint1']?window['activityHint1']:'活动已结束';

            this.nostartGroup.visible = false;
            this.bg.visible = true;
        }
        if(this.mdata.type == 2)
        {

            this.nostartGroup.visible = false;
            this.bg.visible = true;
            this.nostartLb.text = window['activityHint2']?window['activityHint2']:'暂无资格参与';
            this.hintLab.text = window['activityHint2']?window['activityHint2']:'暂无资格参与';
        }
        if(this.mdata.type == 3){
            this.nostartGroup.visible = false;
            this.bg.visible = true;
            this.nostartLb.text = window['activityHint3']?window['activityHint3']:'活动暂开始';
            this.hintLab.text = window['activityHint3']?window['activityHint3']:'活动暂开始';
        }
        // if(this.mdata.type == 3)
        // {
        //     if(window['startHint']){
        //         this.startTimeLab.text = window['startHint'];
        //     }else{
        //         let getStartTime:string = window['startTime'];
        //         let startTime = getStartTime.split(' ');
        //         let showTimeLab = startTime[0].split('-');
        //         let timeHour = startTime[1].split(':');
    
        //         let timeNumber = parseInt(timeHour[0]);
        //         let timeNumberlab = '';
        //         if(timeNumber >= 10){
        //             timeNumberlab = timeHour[0];
        //         }else{
        //             let tmpString = timeNumber.toString();
        //             timeNumberlab = tmpString.substr(tmpString.length - 1,1);
        //         }
        //         let showLab = '活动于'+showTimeLab[1]+'月'+showTimeLab[2]+'日'+timeNumberlab+'点'+'开放， 记得来砸蛋哦~';
                
        //         this.startTimeLab.text = showLab;
        //     }
        // }

    }
}
export interface IMsgData{
    title:string,
    content:string,
    btnType:number,
    callBack?:Function,
    closeCallBack?:Function
}