import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';

import { DataManager } from '../../libs/tw/manager/DataManager';
import { playSound, SoundType, toggleSound, playBg } from '../ctrls/soundCtrl';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import StartScene1 from '../startScene/StartScene';
import { GCache } from '../../libs/tc/util/GCache';
import SceneCtrl from '../ctrls/sceneCtrl';

export default class GameScene extends Scene {
  
    //题目总数
    //private questionCount:number = 5;
    private answerCount:number ;
    private questionCount: number;
    //当前答题数
    private questionCur:number;

    //答案
    private answerMap: any;
    //问题
    private subjectMap:any;

    public answer_1:eui.Image;
    public answer_2:eui.Image;
    public answer_3:eui.Image;
    //答案选择按钮
    public btn_1:eui.Button;
    public btn_2:eui.Button;
    public btn_3:eui.Button;

    public subBtn:eui.Button;

    private isChoose:boolean = false;


    private unselected:egret.Texture;
    private selection:egret.Texture;

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        this.subBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_subBtn, this);

        this.btn_1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_1, this);
        this.btn_2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_2, this);
        this.btn_3.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_3, this);
    }

    removeEvents() {
        super.removeEvents();
        this.subBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_subBtn, this);

        this.btn_1.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_1, this);
        this.btn_2.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_2, this);
        this.btn_3.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickChoose_3, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
    protected async preLoadRes() {
        this.answerCount = 3 ;
        this.questionCount = 5;
        this.questionCur = 1;
        this.subjectMap = this.subjectMap || {};
        this.answerMap = this.answerMap || {};
        this.unselected = await RES.getResAsync('Unselected_png');
        this.selection = await RES.getResAsync('Selection_png');
        //题目图片
        for(let subjectIndex = 1; subjectIndex <= this.questionCount ; subjectIndex++)
        {
            this.subjectMap[subjectIndex] = await RES.getResAsync('subject_'+subjectIndex+"_png");
        }
        //问题图片
        for(let questionIndex = 1; questionIndex <= this.questionCount ; questionIndex++)
        {
            for(let answerIndex = 1; answerIndex <= this.answerCount ; answerIndex++)
            {
                this.answerMap["question_"+questionIndex+"_"+answerIndex] = await RES.getResAsync("question_"+questionIndex+"_"+answerIndex+"_png");
            }
        }
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initSceneData();
    }
    
    //初始化题目
    private initSceneData(): void {
        this.updatePanel(false);
    }
    //总分数
    private score = 0;
    private updatePanel(isInit:boolean){
        if(isInit)
        {
            if(!this.lateClickBtn)
            {
                console.log("未选择");
                return;
            }
            this.lateClickBtn.enabled = true;
            this.lateClickBtn = null;
            this.questionCur ++;
        }
        this.score += this.tmpScore;
        if(this.questionCur > 5)
        {
            console.log('分数',this.score);
            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, {score:this.score});
            return;
        }
        this.updateQuestion();
        this.updateAnswer();
    }
    private updateQuestion(){
        this['subject'].texture = this.subjectMap[this.questionCur];
    }
    private updateAnswer(){
        this.setTexture(this.answer_1,this.answerMap["question_"+this.questionCur+"_"+1]);
        this.setTexture(this.answer_2,this.answerMap["question_"+this.questionCur+"_"+2]);
        this.setTexture(this.answer_3,this.answerMap["question_"+this.questionCur+"_"+3]);
    }
    private setTexture(tmpNode,tmpTexture){
        tmpNode.texture =  tmpTexture;
        tmpNode.width = tmpTexture.width;
        tmpNode.height = tmpTexture.height;
    }
    onTap_subBtn(){
        this.updatePanel(true);
    }

    //临时分数
    private tmpScore = 0;
    private lateClickBtn:any;
    onClickChoose_1(e:egret.TouchEvent){
        this.setButton(this.btn_1);
        this.tmpScore = 1;
    }
    onClickChoose_2(e:egret.TouchEvent){
        this.setButton(this.btn_2);
        this.tmpScore = 2;
    }
    onClickChoose_3(e:egret.TouchEvent){
        this.setButton(this.btn_3);
        this.tmpScore = 3;
    }
    private setButton(tmpBtn:eui.Button){
        tmpBtn.enabled = false;
        if(this.lateClickBtn)
        {
            this.lateClickBtn.enabled = true;
        }
        this.lateClickBtn = tmpBtn;
    }
}