"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var MsgPanel = (function (_super) {
    __extends(MsgPanel, _super);
    function MsgPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.mData = data;
        return _this;
    }
    Object.defineProperty(MsgPanel.prototype, "skinKey", {
        // private tfArr:egret.TextField[];
        get: function () { return 'Msg'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MsgPanel.prototype, "groupName", {
        get: function () { return 'msg_panel'; },
        enumerable: true,
        configurable: true
    });
    MsgPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    };
    MsgPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    MsgPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        if (this.mData && this.mData.btnName) {
            this[this.mData.btnName].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        }
    };
    MsgPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this[this.mData.btnName].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    MsgPanel.prototype.onLoad = function () {
        // if(this.mData.titleIdx == 4 || this.mData.titleIdx == 2){
        //     //网络异常曝光
        //     let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        //     let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        //     let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        //     NetManager.ins.showLog(exposure);
        // }
        this.okBtn.name = 'okBtn';
        this.againBtn.name = 'againBtn';
        this.loginBtn.name = 'loginBtn';
        if (this.mData) {
            this.setBtn();
            console.log('this.mData.titleIdx=' + this.mData.titleIdx);
            if (this.mData.titleIdx != 5) {
                this.setText();
                this.titleImg.visible = true;
            }
            else {
                this.titleImg.visible = false;
            }
        }
        else {
            console.log("this.mData和this.mData.msgArr为必传项！");
        }
        if (this.mData.titleIdx > 3) {
            this.textLabel.visible = true;
            this.textLabel0.visible = true;
            this.textLabel0.text = this.mData.msg0 ? this.mData.msg0 : '';
            this.textLabel.text = this.mData.msg ? this.mData.msg : '';
        }
        else {
            this.textLabel.visible = false;
            this.textLabel0.visible = false;
        }
        this.showAct();
    };
    MsgPanel.prototype.onTap = function (e) {
        panelCtrl_1.default.instance.btnDelay(this[this.mData.btnName]);
        this.hidePanel();
        if (this.mData && this.mData.callBack) {
            this.mData.callBack();
        }
        // if(this.mData.titleIdx == 4 || this.mData.titleIdx == 2){
        //     //网络异常dianji
        //     let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        //     let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        //     let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        //     NetManager.ins.clickLog(exposure);
        // }
    };
    MsgPanel.prototype.onTouchTap = function () {
        _super.prototype.onTouchTap.call(this);
        if (this['closeBtn']) {
            panelCtrl_1.default.instance.btnDelay(this['closeBtn']);
        }
        if (this.mData && this.mData.closeCallBack) {
            this.mData.closeCallBack();
        }
        // if(this.mData.titleIdx == 4 || this.mData.titleIdx == 2){
        //     //网络异常dianji
        //     let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        //     let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        //     let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        //     NetManager.ins.clickLog(exposure);
        // }
    };
    MsgPanel.prototype.setText = function () {
        this.titleImg.source = 'msgTitle' + this.mData.titleIdx + '_png';
    };
    MsgPanel.prototype.setBtn = function () {
        this['okBtn'].visible = false;
        this['againBtn'].visible = false;
        this['loginBtn'].visible = false;
        this[this.mData.btnName].visible = true;
    };
    return MsgPanel;
}(Panel_1.default));
exports.default = MsgPanel;
__reflect(MsgPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/msgPanel/MsgPanel\".MsgPanel");
//# sourceMappingURL=MsgPanel.js.map