const merge = require('webpack-merge');
const common = require('./webpack.common.js');
const webpack = require('webpack');
const MockWebpackPlugin = require('mock-webpack-plugin');
const mockConfig = require('./mock/config.js');

module.exports = merge(common, {
    devtool: 'eval-source-map',
    devServer: {
        host: '0.0.0.0',
        contentBase: '.',
        proxy: {
            '/ngapi/*': 'http://localhost:3000',
            '/plugin/*': 'http://localhost:3000',
            '/ngame/*': 'http://localhost:3000',
            '/activityCommon/*': 'http://localhost:3000',
            '/customActivity/*': 'http://localhost:3000',
            '/ctool/*': 'http://localhost:3000',
            '/activityVist/*': 'http://localhost:3000',
            '/collectGoods/*': 'http://localhost:3000',
            '/activityPlugDrawInfo/*': 'http://localhost:3000',
            '/collectRule/*': 'http://localhost:3000',
            '/hdtool/*': 'http://localhost:3000',
            '/activityPlugin/*': 'http://localhost:3000',
            '/summer/*': 'http://localhost:3000'
        },


    },
    plugins: [
        new MockWebpackPlugin({
            config: mockConfig,
            port: 3000
        })
    ]
});