import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";

const { TouchEvent } = egret;
export default class PlayScene extends Scene{
    protected get skinKey() { return 'Play' }

    public rulePanel:eui.Panel;
    public bg:eui.Image;
    public ele1:eui.Image;
    public uploadBtn:eui.Button;
    public photoPanel:eui.Panel;

    constructor(){
        super()
        this.show();
    }

    show(){
        let scope = this;
        navigator.getUserMedia = navigator['getUserMedia'] || navigator['webkitGetUserMedia'] || navigator['mozGetUserMedia'] || navigator['msGetUserMedia'];
        window.URL = window['URL'] || window['webkitURL'] || window['mozURL'] || window['msURL'];

    }

    initEvents() {
        this.uploadBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClick_uploadBtn,this);
        
    }

    removeEvents() {
        this.uploadBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClick_uploadBtn,this);
        
    }

    // 上传图片
    private onClick_uploadBtn(e:egret.TouchEvent){
        // let file = document.getElementById('photo');
        // if (this.getIos()) {
        //     file.removeAttribute("capture");
        // // }
        PanelCtrl.instance.show(ModuleTypes.PHOTO_PANEL, this)
        this.playSceneVisibleHandler(false);
        window["$"]("canvas").eq(0)[0].style['width'] = window.innerWidth + "px";
        window["$"]("canvas").eq(0)[0].style['height'] = window.innerHeight + "px";
        window['$']('#image').click();
    }

    // 调用拍照或相册
    private onClick_photoBtn(e:egret.TouchEvent){
        PanelCtrl.instance.show(ModuleTypes.PHOTO_PANEL, this)
        this.playSceneVisibleHandler(false);
        window["$"]("canvas").eq(0)[0].style['width'] = window.innerWidth + "px";
        window["$"]("canvas").eq(0)[0].style['height'] = window.innerHeight + "px";
    }

    private playSceneVisibleHandler(isShow:boolean){
        this.bg.visible = isShow;
        this.ele1.visible = isShow;
        this.uploadBtn.visible = isShow;
    }

    private getIos(){
        let ua:string = navigator.userAgent.toLowerCase();
        if (ua.match(/iPhone\sOS/i)) {
            return true;
        } else {
            return false;
        }
    }

}