import Scene from "../views/Scene";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { GamePlayModel ,TwFun} from "../../libs/tw/index";
import { GameStartModel } from "../../libs/tw/index";
import { DataManager } from "../../libs/tw/manager/DataManager";
import submitAfterDostart from "../../libs/new_tw/ctrls/submitAfterDostart";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import showAlertPanel from "../ctrls/showAlertPanel";
import Panel from "../views/Panel";
import MovieClipManager from "../MovieClipManager"
import { GDispatcher } from "../../libs/tc/index";

const { TouchEvent } = egret;
export default class StartScene extends Scene {
    static NET_RANGE = 200;

    public bg:eui.Image;
    public image:eui.Image;
    public ruleBtn:eui.Button;
    public optionBtn:eui.Button;
    public startBtn:eui.Button;
    public rectTop:eui.Rect;
    public progressCon:eui.ProgressBar;
    public image0:eui.Image;
    public playBtn:eui.Button;
    public yuPosition:eui.Rect;

    
    
    
    

    //动画
    public logo: egret.tween.TweenGroup;
    public countNumber: egret.tween.TweenGroup;
    public holed: egret.tween.TweenGroup;
    public startA: egret.tween.TweenGroup;
    public shuipao: egret.tween.TweenGroup;
   // public hb: egret.tween.TweenGroup;
    


    async start(data?) {
        let res
        this.loadResTimeClear["res"]=setInterval(()=>{
        res = MovieClipManager.instance.getMovieClipByName("yu1_0");
            if(!res){return}else{
                clearInterval(this.loadResTimeClear["res"]);
                this.loadResTimeClear["res"]=true;
                console.log(this.loadResTimeClear["res"])
            }
            this.initUI();
            this.initModel2()
            this.initModel()
        },200)
      
    }

    /**
     * 数据
     */
    protected model: GamePlayModel;

    protected initModel(): void {
        this.model = new GamePlayModel();
        this.model.update()
    }

     /**
     * 数据
     */
    protected model2: GameStartModel;

    protected initModel2(): void {
        this.model2= new GameStartModel();
    }

    private loadResTimeClear=[];
    private TimeClear=[];

    private yu1;
    private yu2;
    private yu3;

    private num1;
    private num2;

    private initUI() {
            setInterval(()=>{
                this.logo.play(0);
            },1300)

            setInterval(()=>{
                this.shuipao.play(0);
            },2000)

            this.playBtn.visible=false;
            this.startBtn.visible=true;
            
            this.num1 = MovieClipManager.instance.getMovieClipByName("number_1");
            this.num2 = MovieClipManager.instance.getMovieClipByName("number_0");
            this.yu1 = MovieClipManager.instance.getMovieClipByName("yu1_0");
          
            this.yu1.gotoAndPlay(0,-1)
            this.yuPosition.addChild(this.yu1)

            this.yu2 = MovieClipManager.instance.getMovieClipByName("yu2_0");
            this.yu2.play(0)
            this.yu2.visible=false;
            this.yuPosition.addChild(this.yu2)

            this.yu3 = MovieClipManager.instance.getMovieClipByName("yu3_0");
            this.yu3.play(0)
            this.yu3.visible=false;
            this.yuPosition.addChild(this.yu3)

            this.num1.gotoAndStop(3);
            this.rectTop.addChild(this.num1)
            this.num1.x=-30;
            this.num1.y=0;

            this.num2.gotoAndStop(0);
            this.rectTop.addChild(this.num2)
            this.num2.x=30;
            this.num2.y=0;
            

            this.progressCon.value=0;
           

       
        GDispatcher.addEvent("FirstTipsPanelClose",()=>{
            this.TimeClear["An_1"]=setTimeout(()=>{
                this.holed.play(0)
                this.TimeClear["An_2"]=setTimeout(()=>{
                    this.progressCon["hb"].play()
                    this.progressCon["countText"].text="0"
                },500)
            },500)
        },this)
        
        NetManager.ins.getInfo(() => {

        });

        PanelCtrl.instance.show(ModuleTypes.FIRSTTIPS_PANEL);
    }


    protected initEvents(){
        super.initEvents()
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_recordBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.playBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_playBtn, this);
    }

    private gameTime=20;

    private startAnimte(){
        clearTimeout(this.TimeClear["An_1"])
        clearTimeout(this.TimeClear["An_2"])
        this.holed.stop()
        this.playBtn.visible=true;
        this.startBtn.visible=false;
        this.startA.play()
        this.countNumber.play(0)

        this.TimeClear["gameTime"]=setInterval(()=>{
            this.gameTime--;
            var _t=this.gameTime.toString()
            if(_t.length==2){
                this.num1.gotoAndStop(parseInt(_t[0])+1)
                this.num2.gotoAndStop(parseInt(_t[1])+1)
            }else if(_t.length==1){
                this.num1.gotoAndStop(0)
                this.num2.gotoAndStop(parseInt(_t[0])+1)
            }
            if(this.gameTime<=0){
                clearInterval(this.TimeClear["gameTime"]);
                this.gameOver()
            }
        },1000)
    }

    private onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    private onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    protected onClick_recordBtn(e: egret.Event): void {
       // this.delayEnable(this.view.recordBtn, 5000);
        window.location.href = TwFun.getRecordUrl('00');
    }

    private onTap_startBtn(e: egret.Event) {
       // PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
       this.model.doStart(this.doStart_result.bind(this), false);
    }
    private onTap_playBtn(e: egret.Event) {
        // PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
        this.yu1.visible=false;
        this.yu2.visible=true;
        this.yu3.visible=false;
        this.yu2.gotoAndPlay(0)
        this.yu2.addEventListener(egret.Event.COMPLETE,()=>{
            this.yu3.visible=true;
            this.yu2.visible=false;
            this.yu3.gotoAndPlay(0)
        })

     /*    setTimeout(()=>{
            this.yu3.visible=true;
            this.yu2.visible=false;
            this.yu3.gotoAndPlay(0)
        },1000) */

       /*  setTimeout(()=>{
            this.yu1.visible=true;
            this.yu2.visible=false;
            this.yu3.visible=false;
            this.yu1.gotoAndPlay(0,-1)
        },2000) */

        this.yu3.addEventListener(egret.Event.COMPLETE,()=>{
            this.yu1.visible=true;
            this.yu2.visible=false;
            this.yu3.visible=false;
            this.yu1.gotoAndPlay(0,-1)
        })
        console.log("this.yu2")
        console.log(this.yu2)
       // this.gameOver()
     }

    protected doStart_result(success: boolean): void {
       // this.enableMouseEvt(true);
        if(!success) {
            return;
        }

        this.startAnimte()
        
    }

    protected gameOver(): void {
       // this.enableMouseEvt(true);
       // this.removeEvent();
       // this.model.cacheMaxScore(this.score);
        this.model.submit(this.submit_result.bind(this), 10);
    }

    protected submit_result(success: boolean): void {
      //  this.enableMouseEvt(true);
        if(!success) {
            return;
        }
        let moduleName;
        if (this.model.gameIsWinning) {
            moduleName = ModuleTypes.PRIZE_PANEL;
        } else {
            moduleName = ModuleTypes.LOSE_PANEL;
        }
       // ModuleManager.ins.openModule(moduleName);
        PanelCtrl.instance.show(moduleName);
    }

    protected get skinKey() { return 'Start' }

}