import Panel from "../views/Panel";
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (!DataManager.ins.getRuleData)
            NetManager.ins.getRule(() => {
                this.addRule();
            });
        else
            this.addRule();
    }

    group:eui.Group;

    protected config={
        x:15.5,
        y:"50%",
        width:70,
        marginTop:-38.5,
        height:81,
        lineHeight:7,
        fontSize:4,
        color:"#c56010"
    }
    private htmlNode;

    private clearTime;
    
    private addRule() {
       // alert()
        let text: string = DataManager.ins.getRuleData.ruleText;
        console.log(DataManager.ins.getRuleData.ruleText)
        this.htmlNode=document.createElement("DIV")
        this.htmlNode.setAttribute("style",`position: fixed;overflow-x: hidden;margin-top:${this.config.marginTop}vw ;overflow-y: auto;top: ${this.config.y}; left: ${this.config.x}vw;width: ${this.config.width}vw;height: ${this.config.height}vw;line-height: ${this.config.lineHeight}vw;font-size: ${this.config.fontSize}vw;color: ${this.config.color}`)
        this.htmlNode.setAttribute("id",`htmlNode`)
        this.htmlNode.innerHTML=text
        clearTimeout(this.clearTime)
        this.clearTime=setTimeout(()=>{
            document.body.appendChild(this.htmlNode)
        },500)
       
    }

    hidePanel(){
        super.hidePanel()
        console.log(document.body)
        if(document.getElementById("htmlNode")){
            document.body.removeChild(this.htmlNode)
        }
    }

    protected get skinKey() { return 'Rule' }
}