export default class MovieClipManager {
   
    static _instance: MovieClipManager;
    public static get instance() {
        return MovieClipManager._instance || (MovieClipManager._instance = new MovieClipManager())
    }

    public movieClipPool:any[] = [];
    // 影片剪辑的配置属性
    public movieClipNamePool:any[] = [
        {name:'yu1', dataName:'yu1', num:1},
        {name:'yu2', dataName:'yu2', num:1},
        {name:'yu3', dataName:'yu3', num:1},
        {name:'npc_y1', dataName:'npc_y1', num:5},
        {name:'npc_y2', dataName:'npc_y2', num:5},
        {name:'npc_d1', dataName:'npc_d1', num:5},
        {name:'npc_d2', dataName:'npc_d2', num:5},
        {name:'npc_d3', dataName:'npc_d3', num:5},
        {name:'shui', dataName:'shui', num:5},
       
        {name:'number', dataName:'number2', num:2},
    ];

    // 初始化
    public init(){
       this.initMovieClip();
    }

    // 初始化影片剪辑
    private initMovieClip():void{
        for(let m = 0; m < this.movieClipNamePool.length; m++){
            this.ayncLoad2Mc(`${this.movieClipNamePool[m].name}_json`);   
        }
    }

    // 异步加载动画资源
    private ayncLoad2Mc(resname : string) : void{
        RES.getResAsync(resname,this.onLoad.bind(this),this);
    }

    // 加载完的回调
    private onLoad(data: any,key: string){
        let scope = this;
        for(let m = 0; m < scope.movieClipNamePool.length; m++){
            if(key == `${scope.movieClipNamePool[m].name}_json`) {
                scope.ayncLoad2Mc(`${scope.movieClipNamePool[m].name}_png`);
            }else if(key == `${scope.movieClipNamePool[m].name}_png`){
                for(let i = 0; i < scope.movieClipNamePool[m].num; i++){
                    let data2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_json`);
                    let texture2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_png`);
                    let mcFactory : egret.MovieClipDataFactory = new egret.MovieClipDataFactory(data2mc,texture2mc);
                    let mc:egret.MovieClip = new egret.MovieClip(mcFactory.generateMovieClipData(`${scope.movieClipNamePool[m].dataName}`));
                    mc.name = `${scope.movieClipNamePool[m].name}_${i}`;
                    console.log(mc.name)
                    scope.movieClipPool.push(mc);
                }
            }
        }

        console.log(RES)
        
    }

    // 获取单个影片剪辑
    public getMovieClipByName(name:string):any{
        for(let mc = 0; mc < this.movieClipPool.length; mc++){
            if(this.movieClipPool[mc].name == name){
                return this.movieClipPool[mc];
            }
        }
    }

}