import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import getOptionImgSize from "./data/getOptionImgSize";
import ImgSizeType from "./data/ImgSizeType";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import showLog from "./ctrl/showLog";
export default class PrizePanel extends Panel {
    start(data) {
        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        this.data = lottery;

        const sizeType = getOptionImgSize(lottery);
        if (ImgSizeType.BIG === sizeType) {
            this.img.width = this.picBigWidth;
            this.img.height = this.picBigWidth / this.bigPicRatio;
        } else {
            this.img.width = this.img.height = this.picWidth;
        }

        this.img.y=750;

        showLog(lottery);
    }

    get picWidth() { return 240 };
    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    img: eui.Image;
    useBtn: eui.Button;
    protected get skinKey() { return 'Prize' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}