import { IDynamicData } from "../../tw/data/game/datapash/IDynamicData";
import { NetManager } from "../../tw/manager/NetManager";
import { DataManager } from "../../tw/manager/DataManager";

/**
 * 提交游戏成绩
 * @param callback 
 * @param score 得分
 * @param checkScore  是否校验得分
 * @param customizedType 定制类型 1推币机    
 */
const submit = (callback: Function, score: number, checkScore?: boolean, customizedType?: number) => {
    const allDynamics = [];
    gameSubmitData(callback, score, allDynamics, checkScore, customizedType);
}

/**
* 提交游戏成绩
* @param callback 
* @param score 得分
* @param allDynamics 防作弊数据
* @param checkScore  是否校验得分
* @param customizedType 定制类型 1推币机    
*/
const gameSubmitData = (callback: Function, score: number, allDynamics: IDynamicData[][], checkScore?: boolean, customizedType?: number) => {
    NetManager.ins.gameSubmit(
        (success: boolean) => {
            if (success) {
                getSubmitResult(callback, DataManager.ins.gameSubmitData.orderId);
            } else {
                callback(success);
            }
        },
        DataManager.ins.doStartData.ticketId,
        score,
        '[]',
        DataManager.ins.doStartData.submitToken,
        JSON.stringify(allDynamics),
        checkScore,
        customizedType);
}

/**
 * 查询提交结果
 * @param callback 
 * @param orderId 
 */
const getSubmitResult = (callback: Function, orderId: number) => {
    NetManager.ins.getSubmitResult(callback, orderId, () => {
        return DataManager.ins.gameGetSubmitResultData.flag;
    });
}

export default submit;