import { award } from "./collisionConfig";
import StartScene from "./StartScene";
import { playBoom, playSuccess, playScoreAni } from "./playMovieClip";
import vibrate from "./vibrate";
import LabelType from "./items/LabelType";
import { createNewBubble } from "./createItems";

const check = (_this: StartScene) => {
    const center = 382;
    const paddingX = 50;
    const ypos = 440;
    const h = 40;
    // _this._egretRender._root.graphics.beginFill(0xff0000, 1);
    // _this._egretRender._root.graphics.drawRect(center - paddingX, ypos, paddingX * 2, h);
    // _this._egretRender._root.graphics.endFill();

    const bodies = Matter.Composite.allBodies(_this._engine.world);
    const isAward = (i: Matter.Body) => { return i.collisionFilter.group == award }
    bodies.forEach(i => {
        if (!isAward(i)) return;
        if (i['timer']) {
            const t0 = Date.now() - i['timer'];
            if (t0 > 3000)//3s之内不可再用
            {
                delete i['timer'];
                // console.log('重新可用', Date.now() / 1000)
            }
        }
        const { x, y } = i.position;
        const xResult = x > (center - paddingX) && x < (center + paddingX);
        const yResult = y > ypos && y < (ypos + h);
        if (xResult && yResult && i.velocity.y > 0 && !i['timer']) {
            i['timer'] = Date.now();
            if (i.label == LabelType.boom) {
                // console.log('boom');
                _this._egretRender.remove(i);
                vibrate(_this, 2);
                playBoom(_this.egretRenderContainer);
                // playScoreAni(_this.egretRenderContainer, -1);
                _this.onBoom();
            }
            // else if(i.label ==LabelType.gift){

            // }
            else {
                // console.log('不是boom，重用', Date.now() / 1000);
                playScoreAni(_this.egretRenderContainer, 1)
                playSuccess(_this.egretRenderContainer);
                const oldscore = _this.addScore();
                checkAdd(_this, oldscore);
            }
            // _this.onGetAward();
        }
    })
}

const checkAdd = (that: StartScene, oldscore) => {
    if (oldscore === 5) {
        createNewBubble(that, LabelType.candy);
    }
    else if (oldscore === 20) {
        createNewBubble(that, LabelType.egg);
    }
    else if (oldscore === that.MAX_SCORE) {
        createNewBubble(that, LabelType.gift);
    }
}

export default check