import { DataManager } from '../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { CustomModel } from './../common/CustomModel';
import { GFun } from '../../../tc/util/GFun';
import { ICustomOptionData } from '../../data/custom/ajaxElement/ICustomOptionData';
/**
 * 自定义活动工具玩法模型
 */
export class CustomPlayModel extends CustomModel {
    /**
     * 次数文案
     */
    public get countTxt(): string {
        let str: string;
        switch (DataManager.ins.ajaxElementData.element.status) {
            case 0:
                break;
            case 1:
                str = TwLang.lang_002;
                break;
            case 3:
                str = TwLang.lang_004 + TwLang.lang_003;
                break;
            case 4:
                str = TwLang.lang_003;
                break;
            case 5:
                str = TwLang.lang_004 + GFun.replace(TwLang.lang_005, [DataManager.ins.ajaxElementData.element.freeLimit]);
                break;
            case 6:
                str = GFun.replace(TwLang.lang_006, [DataManager.ins.ajaxElementData.element.needCredits, DataManager.ins.customCfgData.unitName]);
                break;
            case 7:
                str = GFun.replace(TwLang.lang_005, [DataManager.ins.ajaxElementData.element.freeLimit]);
                break;
            case 18:
                str = TwLang.lang_007;
                break;
        }
        return str;
    }

    /**
     * 奖品列表
     */
    public get optionList(): ICustomOptionData[] {
        return DataManager.ins.ajaxElementData.options;
    }

    /**
     * 活动规则
     */
    public get rule(): any {
        return DataManager.ins.ajaxElementData.rule;
    }
}