import Panel from "../views/Panel";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import ItemRenderder from "./OptionsItemRenderder";
import { IGameOptionData } from "../../tw/data/game/getOptions/IGameOptionData";
export default class OptionsPanel extends Panel {
    start() {
        if (!DataManager.ins.getOptionsData)
            NetManager.ins.getOptions(() => {
                this.updatePanel();
            });
        else
            this.updatePanel();
    }

    group: eui.Group;
    list: eui.List;
    updatePanel() {
        DataManager.ins.getOptionsData.optionList.forEach(item => {
            item['scopeOrigin'] = item['scopeOrigin'] || item.scope;
            item.scope = this.getScope(item);
        });
        this.list.useVirtualLayout = false;
        this.list.itemRenderer = ItemRenderder;
        const ac = new eui.ArrayCollection(DataManager.ins.getOptionsData.optionList);
        this.list.dataProvider = ac;
    }

    getScope(data: IGameOptionData) {
        if (data.autoOpen) {
            return '阳光普照';
        }
        return `第${data['scopeOrigin']}名`;
    }

    protected get skinKey() { return 'Options' }
}