import getIsIOS from "../../new_tc/getIsIOS";
import wait from "../../new_tc/wait";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";
import { isAllLevelPass } from "../../../src/startScene/level";

export default class StartSceneBase extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    rankBtn: eui.Button;
    elements: eui.Group;
    startBtn: eui.Button;
    exemptionTxt: eui.Label;
    countTxt: eui.Label;

    async start(data?) {
        this.startBtn.visible = false;
        if (!isAllLevelPass())
            this.updateGetInfoView();
        this.updateExemptionTxt();
        super.start();
    }

    async playAnimation() {
        const btns = [this.ruleBtn, this.optionBtn, this.recordBtn, this.rankBtn];
        btns.forEach(btn => btn.alpha = 0)

        await wait(400);
        btns.forEach(btn => {
            egret.Tween.get(btn).to({ alpha: 1 }, 700, egret.Ease.backOut);
        });
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    updateStartBtnStatus() {
        if (this.startBtn) {
            this.startBtn.visible =this['startBtnBg'].visible =this.countTxt.visible = true;
            this.startBtn.enabled = getStartBtnEnable();
        }
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getCountTxt();

        }
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        if (this.startBtn)
            this.startBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
    }

    onTap_startBtn(e?: egret.Event) {
        doStart();
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}