//  import { NetManager } from "../../manager/NetManager"; import { DataManager } from "../../manager/DataManager";
import { PetIndexData } from "../../data/pet/PetIndexData";
import { PetHomeInfoData } from './../../data/pet/PetHomeInfoData';
import { SignInfoData } from './../../data/pet/SignInfoData';
import { ActivityModel } from "./ActivityModel";
import { NetManager } from "../../manager/NetManager";
import { DataManager } from "../../manager/DataManager";

export class SignModel extends ActivityModel {
    /**
     * 领养
     * @param callback
     */
    public petAdopte(callback:Function):void{
        NetManager.ins.petAdopte(callback, DataManager.ins.petIndexData.activityId);
    }

    /**
     * 获取宠物信息
     * @param callback 
     */
    public getPetInfo(callback:Function):void{
        NetManager.ins.getPetInfo(callback, DataManager.ins.petIndexData.activityId);
    }

    /**
     * 宠物喂食
     * @param callback 
     * @param feedNum:喂食数量
     */
    public petFeed(callback:Function, feedNum:number):void {
        NetManager.ins.petFeed(callback, DataManager.ins.petHomeInfoData.petId, feedNum);
    }
    
    /**
     * 宠物状态刷新
     * @param callback 
     */
    public getPetStatus(callback: Function): void {
        NetManager.ins.getPetStatus(callback, DataManager.ins.petHomeInfoData.petId);
    }

    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到插件ID
     */
    public doSign(callback: Function, signActivityId: number): void {
        NetManager.ins.doSign(callback, signActivityId, DataManager.ins.petIndexData.activityId);
    }

    
    /**
     * 收取礼物接口
     * @param callback 
     * @param {number} giftId 礼物id
     * @param {string} giftName 礼物名称
     * @param {string} giftDesc 礼物描述
     * @param {number} giftType 礼物类型 1：用户自定义， 2：食物
     * @param {string} giftLink 礼物链接
     * @param {number} petId 宠物id
     */
    public collect(callback: Function, giftId: number, giftNum: number, giftName: string, giftDesc: string, giftType: number, giftLink: string): void {
        NetManager.ins.collect(callback, giftId, giftNum, giftName, giftDesc, giftType, giftLink, DataManager.ins.petHomeInfoData.petId);
    }
    
    /**
     * 用户基础数据
     */
    public get petIndexData():PetIndexData
    {
        return DataManager.ins.petIndexData;
    }

    /**
     * 宠物基础数据
     */
    public get petHomeInfoData():PetHomeInfoData
    {
        return DataManager.ins.petHomeInfoData;
    }

    /**
     * 签到详情数据
     */
    public get signInfoData():SignInfoData
    {
        return DataManager.ins.signInfoData;
    }
}