/**
 *Created by cuiliqiang on 2018/3/12
 * 用户剩余积分数据
 */
import { Data } from "../../Data";

export class GetCreditsData extends Data {
    /**
     * 积分单位
     */
    public unitName: string;

    /**
     * 积分
     */
    public credits: number;

    /**
     * 用户积分
     */
    public consumerCredits: number;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        this.unitName = result.data.unitName;
        this.credits = result.data.credits;
        this.consumerCredits = result.data.consumerCredits;
    }
}