import PanelCtrl from "../../libs/new_tl/ctrls/panelCtrl";
import { ModuleTypes } from "../../libs/new_tl/types/sceneTypes";
import Scene from "../../libs/new_tl/views/Scene";
import doStart from "../../libs/new_tw/ctrls/doStart";
import SceneCtrl from "../../libs/new_tl/ctrls/sceneCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import getStartBtnEnable from "../../libs/new_tw/datas/getStartBtnEnable";
import getCountTxt from "../../libs/new_tw/datas/getCountTxt";
import getIsIOS from "../../libs/new_tc/getIsIOS";

export default class StartScene extends Scene {
    ruleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    startBtn: eui.Button;

    countTxt: eui.Label;
    exemptionTxt: eui.Label;

    async start(data?) {
        this.updateGetInfoView();
        this.updateExemptionTxt();
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    updateStartBtnStatus() {
        if (!this.startBtn) return;
        this.startBtn.visible = true;
        this.startBtn.enabled = getStartBtnEnable();
        egret.Tween.get(this.startBtn).set({ horizontalCenter: 750 }).to({ horizontalCenter: 0 }, 400, egret.Ease.elasticOut);
    }

    updateCountTxt() {
        if (!this.countTxt) return;
        this.countTxt.visible = true;
        this.countTxt.text = getCountTxt();
        egret.Tween.get(this.countTxt).set({ horizontalCenter: 750 }).wait(400).to({ horizontalCenter: 0 }, 300, egret.Ease.backOut);
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        this.startBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
    }

    onTap_startBtn(e: egret.Event) {
        doStart();
        SceneCtrl.instance.change(ModuleTypes.PALY_SCENE);
    }

    protected get skinKey() { return 'Start' }
}