import Alert from "../libs/new_tl/components/Alert";
import OptionsPanel from "../libs/new_tl/components/OptionsPanel";
import PrizePanel from "../libs/new_tl/components/PrizePanel";
import RulePanel from "../libs/new_tl/components/RulePanel";
import PanelCtrl from "../libs/new_tl/ctrls/panelCtrl";
import SceneCtrl from "../libs/new_tl/ctrls/sceneCtrl";
import showAlertPanel from "../libs/new_tl/ctrls/showAlertPanel";
import MainBase from "../libs/new_tl/MainBase";
import { ModuleTypes } from "../libs/new_tl/types/sceneTypes";
import { NetManager } from "../libs/tw/manager/NetManager";
import StartScene from "./startScene/StartScene";
import PlayScene from "./playScene/PlayScene";

class Main extends MainBase {
    protected registerModules() {
        PanelCtrl.instance.registerPanelClass(ModuleTypes.ALERT_PANEL, Alert);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.OPTIONS_PANEL, OptionsPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.PRIZE_PANEL, PrizePanel);

        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.PALY_SCENE, PlayScene);
        NetManager.ins.onNotSuccess = (msg) => {
            showAlertPanel(msg)
        }
    }

    protected getData() {
        super.getData();
        NetManager.ins.getInfo();
    }

    protected async createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}
window['Main'] = Main;
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: (context: any) => {
        const backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});