import MovieClip from "../../physics/movieclip/MovieClip";
import LabelType from "../LabelType";

const createDonut = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const texture = RES.getRes('donut_json');
    const animation = createMovieClip(texture, 98/166 * scale);//中间物体尺寸140px
    return animation
}

const createMovieClip = (spritesheet, scale) => {
    const list = ['礼盒0000', '礼盒0001', '礼盒0002', '礼盒0003', '礼盒0004', '礼盒0005', '礼盒0006',
        '礼盒0007', '礼盒0008', '礼盒0009', '礼盒0010', '礼盒0011', '礼盒0012', '礼盒0013', '礼盒0014', '礼盒0015'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 4,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [217/500, 228/500]
    });
    movieclip.lable = LabelType.Donut
    return movieclip
}

export default createDonut