import createBoom from "./createBoom";
import createCandy from "./createCandy";
import createCoin from "./createCoin";
import createEgg from "./createEgg";
import createGift from "./createGift";
import LabelType from "./LabelType";

const createItem = (scale, type: LabelType) => {
    const funcs = {
        'boom': createBoom,
        'gift': createGift,
        'candy': createCandy,
        'egg': createEgg,
        'coin': createCoin
    };
    const func = funcs[type];
    
    return func(scale);
}
export default createItem