import wait from "../libs/new_tc/wait";
import submitAfterDostart from "../libs/new_tw/ctrls/submitAfterDostart";
import getCountTxt from "../libs/new_tw/datas/getCountTxt";
import Loading from "../libs/new_wx/components/Loading";
import Panel from "../libs/new_wx/components/Panel";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import showAlertPanel from "../libs/new_wx/ctrls/showAlertPanel";
import { ModuleTypes } from "../libs/new_wx/types/sceneTypes";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import gameIsWinning from "../libs/new_tw/datas/gameIsWinning";

export default class TreasurePanel extends Panel {
    start(data) {
        if (!DataManager.ins.getOptionsData)
            NetManager.ins.getOptions(() => {
                this.updatePanel();
            });
        else
            this.updatePanel();
    }

    updatePanel() {
        this.tweenGroup.addEventListener('complete', this.onTweenGroupComplete, this);
        this.tweenGroup.play(0);
        this.bg2.once(egret.TouchEvent.TOUCH_TAP, this.onOpenTreasure, this);
        this.updateCountTxt();
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getCountTxt();
        }
    }

    check() {
        if (DataManager.ins.getInfoData.status.code == 2) {
            showAlertPanel('对不起，您的积分不足。', null, 'lackOfMoney')
            return false;
        }
        if (DataManager.ins.getInfoData.status.code == 3) {
            showAlertPanel('对不起，参与次数已用完。', null, 'lackOfChance')
            return false;
        }
        return true;
    }

    onOpenTreasure() {
        if (!this.check()) return;
        this.tweenGroup.removeEventListener('complete', this.onTweenGroupComplete, this);
        this.tweenGroup.stop();
        this.closeBtns.forEach(btn => btn.touchEnabled = false);
        Loading.instace.show();

        submitAfterDostart(() => {
            if (gameIsWinning()) {
                PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL);
            } else {
                PanelCtrl.instance.show(ModuleTypes.NO_PRIZE_PANEL);
            }

            Loading.instace.hide();
            wait(300).then(() => NetManager.ins.getInfo());
        }, 10);
    }

    private onTweenGroupComplete(): void {
        this.tweenGroup.play(0);
    }

    get skinKey() { return 'Treasure' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    destroy() {
        super.destroy();
        this.tweenGroup.removeEventListener('complete', this.onTweenGroupComplete, this);
    }

    countTxt: eui.Label;
    bg2: eui.Image;
    tweenGroup: egret.tween.TweenGroup;
}