/**
 * 对象池
 */
export class GPool {
    private static pool: any = {};
    private static maxCount = {};

    /**
     * 根据类型设置缓存最大个数
     * @param className
     * @param count
     */
    public static setMaxCountByType(className: any, count): void {
        this.maxCount[className] = count;
    }

    /**
     * 取出
     * @param className 资源名
     * @param 类名
     */
    public static takeOut(className: string, classObj?: any, isCreate?: boolean): any {
        if (!className || className == '') {
            return;
        }
        let obj: any;

        if (this.pool[className] && this.pool[className].length) {
            obj = this.pool[className].shift();
        } else if (isCreate) {
            if (!classObj) {
                classObj = eval(className);
            }
            obj = new classObj();
        }
        return obj;
    }

    /**
     * 回收
     * @param className 资源Class
     * @param obj 资源
     */
    public static recover(className: string, obj: any): void {
        if (!obj || !className) {
            return;
        }
        if (!this.pool[className]) {
            this.pool[className] = [];
        }

        if (!this.maxCount[className]) {
            this.maxCount[className] = 100;
        }

        if (this.pool[className].length > this.maxCount[className]) {
            return;
        }
        this.pool[className].push(obj);
        if (obj['dispose']) {
            obj.dispose();
        }
    }
}