import { DataManager } from './../../../manager/DataManager';
import { Data } from "../../Data";
import { IUserData } from '../common/IUserData';

/**
 *Created by cuiliqiang on 2018/3/9
 * 时时排行榜数据
 */
export class RealTimeRankData extends Data {
    /**
     * 是否在排行榜内
     */
    public inRank: boolean;

    /**
     * 自己的排行数据
     */
    public myUserData: IUserData;

    /**
     * 排行列表
     */
    public userList: IUserData[];

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.inRank = data.data.inRank;
        if (data.data.user) {
            this.myUserData = data.data.user;
            DataManager.ins.getInfoData.rank = this.myUserData.rank;
        }
        this.userList = data.data.userList;
    }
}