// tslint:disable:only-arrow-functions
// tslint:disable:no-conditional-assignment
// tslint:disable:prefer-const
// tslint:disable:no-var-keyword
// tslint:disable:no-inferrable-types

export const degToRad = Math.PI / 180;

export const radToDeg = 180 / Math.PI;

export const sqrt3 = Math.sqrt(3);

export function translateToLocalCor(p, parent) {
    var th = parent.rotation * degToRad;
    //平移
    var xp = p.x - parent.x;
    var yp = p.y - parent.y;
    //旋转
    var x = xp * Math.cos(th) + yp * Math.sin(th);
    var y = yp * Math.cos(th) - xp * Math.sin(th);
    return { x: x / parent.scaleX, y: y / parent.scaleY }
}

export function translateToGlobalCor(p, parent) {
    var th = -parent.rotation * degToRad;
    var x = p.x * Math.cos(th) + p.y * Math.sin(th) + parent.x;
    var y = p.y * Math.cos(th) - p.x * Math.sin(th) + parent.y;
    return { x: x / parent.scaleX, y: y / parent.scaleY }
}

/**
 * 以水平向左即x正方向为0，顺时针为正，返回弧度
 * @param pointFixed 固定点
 * @param point 
 */
export function twoPointsAngleDis(pointFixed, point) {
    var detaX = point.x - pointFixed.x;
    var detaY = point.y - pointFixed.y;
    var dis = Math.sqrt(detaX * detaX + detaY * detaY);
    var angleH = Math.acos(detaX / dis);
    if (detaY < 0) {
        angleH = Math.PI * 2 - angleH;
    }
    return { angle: angleH, dis: dis };
}