import { Circle } from "../physics/Circle";
import PlayScene from "../PlayScene";

export default (that: PlayScene, x, y, num) => {
    let block = that.pool.takeOut("circle");

    if (!block) {
        const sprite = new egret.Sprite();
        sprite.touchEnabled = sprite.touchChildren = false;
        //背景
        const shape = new egret.Bitmap(RES.getRes('circle1_png'));
        shape['__resName__'] = 'circle1_png';
        const radius = shape.width / 2;
        const length = radius * 2;
        shape.anchorOffsetX = shape.width / 2;
        shape.anchorOffsetY = shape.height / 2;
        sprite["bg"] = shape;
        sprite.addChild(shape);

        //数字
        const txt = new egret.TextField();
        txt.width = length;
        txt.height = length;
        txt.anchorOffsetX = length / 2;
        txt.anchorOffsetY = length / 2;
        txt.size = 30;
        txt.textColor = 0xffffff;
        txt.textAlign = egret.HorizontalAlign.CENTER;
        txt.verticalAlign = egret.VerticalAlign.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        block = new Circle(radius, sprite);
    }
    that.addChild(block.view)
    block.x = x;
    block.y = y;
    block.num = num;
    that.blocks.push(block);
    block.ladderNums = 1;
}