import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { HtmlTextParser } from "./HtmlTextParser";

export default class RulePanel extends Panel {


    public ruleBg:eui.Image;
    public ruleBackBtn:eui.Button;
    public ruleLb:eui.Label;
    public textstring:string = "";
    public endstr:string = "";

    private mdata:any;

    public get skinKey() { return 'RulePanel' }
    public get groupName() { return 'rule_panel' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        this.ruleBackBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_closeBtn,this);
    }

    removeEvents() {
        super.removeEvents();

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
 
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map;
    private initUI(): void {
       
        let data = DataManager.ins.getData(NetName.projectRule).data;
        this.textstring = data;
        this.replaceWord();
        if(data){
            this.ruleLb.textFlow = (new HtmlTextParser).parser(this.textstring);
        }else{
            this.ruleLb.text = window["rule"];
        }
        
    } 

    onTap_closeBtn(){
        this.hidePanel();
    }

    replaceWord(){

        if (this.textstring.search("</p>") == -1) {
            if(this.endstr){
                this.textstring = this.endstr;
            }
        } else {
            this.textstring = this.textstring.replace("</p>", "</p><br>");
            this.endstr = this.endstr.concat(this.textstring.slice(0, this.textstring.search("</p>") + 8));
            this.textstring = this.textstring.slice(this.textstring.search("</p>") + 8, this.textstring.length);
            this.replaceWord();
        }
    }
    
}