
import Panel from '../views/Panel';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';

export default class RankPanel extends Panel {


    public panelGroup: eui.Group;

    public closeBtn: eui.Button;
    public myrank:eui.Component;
    public rankList:eui.Scroller;
    public rankGroup:eui.Group;
    public shareBtn:eui.Button
    public mybg:eui.Image;

    private rankdata:any;
    private mydata:any;

    private shareExposure:any;
    private showExposure:any;

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data?) {
        super(data);
        console.log("rankdata:",data)
        this.mydata = data.mydata;
        console.log(this.mydata)
        this.rankdata = data.rankdata;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_closeBtn,this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);
    }

    removeEvents() {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_closeBtn,this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);
        

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }

    private initUI(): void {
        // if(this.mdata){
        //     if
        // }
        let showDpmOut = Buried.connectDpm(110, 16, 1); // 点击埋点   
        let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
        NetManager.ins.showLog(this.showExposure);

        let shareDpmOut = Buried.connectDpm(110, 19, 1); // 点击埋点   
        let shareDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.shareExposure = Buried.createExposure(shareDpmOut, shareDcmOut);
        NetManager.ins.showLog(this.shareExposure);
        
        if(this.mydata){
            // this.myrank
            this.myrank["rankline"].visible = false;
            for(let i = 0;i<this.rankdata.length;i++){
                if(this.mydata.adcode == this.rankdata[i].adcode){
                    if(this.mydata.adcode==110000 
                        || this.mydata.adcode==120000 
                        || this.mydata.adcode==310000 
                        || this.mydata.adcode==500000
                        || this.mydata.adcode==710000
                        || this.mydata.adcode==810000
                        || this.mydata.adcode==820000){
                           this.myrank["place"].text = this.mydata.province
                        }else{
                            let tempArr = [];
                            tempArr = this.mydata.city.split('市');
                            let newStr = tempArr.join('');
                            this.myrank["place"].text = this.mydata.province+newStr
                        }
                    this.myrank["rank"].text = i+1;
                    this.myrank["rank"].visible = false;
                    this.myrank["rankimg"].visible = true;
                    this.myrank["ranknum"].text = this.rankdata[i].count;
                    if(i+1 == 1){
                        this.myrank["rankimg"].source = "rankfirst_png";
                    }else if(i+1==2){
                        this.myrank["rankimg"].source = "ranksecond_png";
                    }else if(i+1 == 3){
                        this.myrank["rankimg"].source = "rankthird_png";
                    }else{
                        this.myrank["rank"].visible = true;
                        this.myrank["rankimg"].visible = false;
                    }
                }
            }
        }else{
            this.mybg.visible =false;
            this.myrank.visible = false;
            let listheight = this.rankList.y - 265
            this.rankList.y = 265;
            this.rankList.height += listheight;
        }
        if(this.rankdata){
            for(let i = 0;i<this.rankdata.length;i++){
                let rankItem = new eui.Component();
                rankItem.skinName = "RankItemSkin"
                rankItem.y = i*80 
                if(this.rankdata[i].adcode==110000 
                    || this.rankdata[i].adcode==120000 
                    || this.rankdata[i].adcode==310000 
                    || this.rankdata[i].adcode==500000
                    || this.rankdata[i].adcode==710000
                    || this.rankdata[i].adcode==810000
                    || this.rankdata[i].adcode==820000){
                        rankItem["place"].text = this.rankdata[i].province
                    }else{
                        let tempArr = [];
                        tempArr = this.rankdata[i].city.split('市');
                        let newStr = tempArr.join('');
                        rankItem["place"].text = this.rankdata[i].province+newStr
                    }
                rankItem["rank"].text = i+1;
                rankItem["rank"].visible = false;
                rankItem["rankimg"].visible = true;
                rankItem["ranknum"].text = this.rankdata[i].count;
                if(i+1 == 1){
                    rankItem["rankimg"].source = "rankfirst_png";
                }else if(i+1==2){
                    rankItem["rankimg"].source = "ranksecond_png";
                }else if(i+1 == 3){
                    rankItem["rankimg"].source = "rankthird_png";
                }else{
                    rankItem["rank"].visible = true;
                    rankItem["rankimg"].visible = false;
                }
                this.rankGroup.addChild(rankItem);
            }
        }
    }

    onTap_closeBtn(){

        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        this.hidePanel();

    }
    onTap_shareBtn(){
        NetManager.ins.clickLog(this.shareExposure);
        PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL);
    }
 
}