import { TwFun } from './../../libs/tw/util/TwFun';
import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetName } from '../../libs/tw/enum/NetName';
import { NetPromise } from '../NetPromise';
import { NetBuried } from '../NetBuried';
export default class PrizePanel extends Panel {
    private mdata: any;

    

    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public prizeImg: eui.Image; 
    public prizename: eui.Label;
    public getBtn: eui.Button;
    private useExposure:any;


    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        //joinDo:DataManager.ins.getData(NetName.joinDo).data,
        //prizeQuery:DataManager.ins.getData(NetName.prizeQuery).data
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    hideAll(){
        this.prizeImg.visible=false
        this.prizename.visible=false
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.getBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        //this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.getBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
       // this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    private async onLoad() {

        this.hideAll()
        this.initUI()
        
    }
    initUI(){
        let useDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
        let useDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.useExposure = Buried.createExposure(useDpmOut, useDcmOut);
        NetManager.ins.showLog(this.useExposure);
        PanelCtrl.instance.btnAni(this.getBtn);
        console.log(this.mdata);
        this.prizeImg.source = this.mdata.prizeIcon;
        this.prizename.text = this.mdata.prizeName;
        this.prizename.visible = true;
        this.prizeImg.visible = true;
    }


    onUse() {
        //        
        //PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:10})
        // PanelCtrl.instance.btnDelay(this.iknowBtn)
        // PanelCtrl.instance.btnDelay(this.iknowKhBtn)
        // PanelCtrl.instance.btnDelay(this.iknowRedBtn)
        NetManager.ins.clickLog(this.useExposure);
        this.hidePanel()
        window.location.href = this.mdata.url
    }


    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        this.hidePanel()
    }
}