import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetPromise } from '../NetPromise';
export default class NoPrizePanel extends Panel {

    public panelGroup: eui.Group;
    public knowBtn: eui.Button;
    public closeBtn: eui.Button;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'NoPrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        // this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_againBtn() {
       this.onTap_closeBtn()
    }

    onTap_closeBtn() {
        this.onTouchTap()
        // NetPromise.ins.gotoIndex()
        this.hidePanel()
    }
}