import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import Panel from '../views/Panel';

export default class PlacePanel extends Panel {


    private timer: egret.Timer;

    private mdata:any;

    public shengList:eui.Scroller;
    public shengGroup:eui.Group;
    public shiList:eui.Scroller;
    public shiGroup:eui.Group;

    public closeBtn:eui.Label;
    public sureBtn:eui.Label;
    private choseadcode:number = 110000;
    private shengname = "";
    private shiname = "";
    private shifun:any;

    public get skinKey() { return 'PlacePanel' }
    public get groupName() { return 'time_panel' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_closeBtn,this);
        this.sureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_choseBtn,this);

    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }

    private initUI(): void {
        // if(this.mdata){
        //     if
        // }
        console.log("进入选择城市页面")
        this.showshengInfo();
    }

    showshengInfo(){
        if(this.mdata){
            let kong = new eui.Rect();
            kong.alpha = 0;
            kong.width = 348
            kong.height = 192;
            kong.y = 0;
            this.shengGroup.addChild(kong);
            for(let i = 0;i<this.mdata.length;i++){
                let sheng = new eui.Label();
                sheng.width = 348;
                sheng.height = 66;
                sheng.textAlign = "center";
                sheng.verticalAlign = "middle";
                sheng.text = this.mdata[i].name;
                sheng.textColor = 0x343434
                sheng.y = 192 + i*66;
                this.shengGroup.addChild(sheng);
            }
            let kong2 = new eui.Rect();
            kong2.alpha = 0;
            kong2.width = 348
            kong2.height = 198;
            kong2.y = 192+this.mdata.length*66;
            this.shengGroup.addChild(kong2);
            this.shengname = this.mdata[0].name;
            this.choseadcode = this.mdata[0].adcode;
        }
        
        this.shengList.addEventListener(eui.UIEvent.CHANGE_END,this.onshengLeave,this);
    } 

    onshengLeave(){
        let listy = this.shengList.viewport.scrollV; 
        
        let itemnum = Math.floor((listy)/66);
        this.shiList.removeEventListener(eui.UIEvent.CHANGE_END,this.onshiLeave,this);
        this.shiGroup.removeChildren();
        this.shiList.viewport.scrollV = 0;
        this.shiname = "";
        if((listy)%66<33){

        }else{
            itemnum+=1;

        }
        this.shengList.viewport.scrollV = itemnum*66
        this.shengname = this.mdata[itemnum].name;
        this.choseadcode = this.mdata[itemnum].adcode;
        console.log("当前itemnum:", itemnum,"adcode",this.mdata[itemnum].adcode)
        if(this.mdata[itemnum].adcode==110000 
            || this.mdata[itemnum].adcode==120000 
            || this.mdata[itemnum].adcode==310000 
            || this.mdata[itemnum].adcode==500000
            || this.mdata[itemnum].adcode==710000
            || this.mdata[itemnum].adcode==810000
            || this.mdata[itemnum].adcode==820000){
            console.log("直辖市itemnum:", itemnum,"adcode",this.mdata[itemnum].adcode)
            // this.chosename = this.mdata[itemnum].name;
        }else{
            NetPromise.ins.adList(this.choseadcode)
            .then(()=>{
                let data = DataManager.ins.getData(NetName.adList).data
                // PanelCtrl.instance.show(ModuleTypes.PLACE_PANEL,data)
                this.showshiInfo(data);
                this.choseadcode = data[0].adcode
                this.shiname = data[0].name;
            })
            .catch(()=>{
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL);
            })
        }
    }

    showshiInfo(data){
        if(data){
            let kong = new eui.Rect();
            kong.alpha = 0;
            kong.width = 348
            kong.height = 192;
            kong.y = 0;
            this.shiGroup.addChild(kong);
            for(let i = 0;i<data.length;i++){
                let shi = new eui.Label();
                shi.width = 348;
                shi.height = 66;
                shi.textAlign = "center";
                shi.verticalAlign = "middle";
                let tempArr = [];
                tempArr = data[i].name.split('市');
                let newStr = tempArr.join('');
                shi.text = newStr;
                shi.textColor = 0x343434
                shi.y = 192 + i*66;
                this.shiGroup.addChild(shi);
            }
            let kong2 = new eui.Rect();
            kong2.alpha = 0;
            kong2.width = 348
            kong2.height = 198;
            kong2.y = 192+data.length*66;
            this.shiGroup.addChild(kong2);
        }
        console.log("shi:",data)
        this.shifun = data
        this.shiList.addEventListener(eui.UIEvent.CHANGE_END,this.onshiLeave,this);
    } 
    onshiLeave(){
        console.log("该省份data：",this.shifun)
        let listy = this.shiList.viewport.scrollV; 
        
        let itemnum = Math.floor((listy)/66)
        if((listy)%66<33){

        }else{
            itemnum+=1;

        }
        this.shiList.viewport.scrollV = itemnum*66
        
        this.choseadcode = this.shifun[itemnum].adcode
        this.shiname = this.shifun[itemnum].name;
    }

    onTap_closeBtn(){

        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        this.hidePanel();

    }
 
    onTap_choseBtn(){
        this.hidePanel();
        // sc.instance.show(ModuleTypes.CHOSECITY_PANEL)
        let data = {adcode:this.choseadcode,shengname:this.shengname,shiname:this.shiname};
        SceneCtrl.instance.change(ModuleTypes.CHOSE_SCENE,data);

    }

    // onTap_chosecity(){
    //     NetPromise.ins.maadListpInfo()
    //     .then(()=>{
    //         PanelCtrl.instance.show(ModuleTypes.PLACE_PANEL)
    //     })
    //     .catch(()=>{
    //         PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL);
    //     })

    // }
}