import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';

export default class ChoseScene extends Scene {


    private timer: egret.Timer;

    private adcode:any = 111;
    private province:any;
    private city:any;

    public choseBtn:eui.Button;
    public backBtn:eui.Button;
    public cityImg:eui.Image;
    public chosecity:eui.Image;
    public cityname:eui.Label;

    private showExposure:any;
    private choseExposure:any;
    private sureExposure:any;

    private mdata:any;

    public get skinKey() { return 'ChoseScene' }
    public get groupName() { return 'chose_panel' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_backBtn,this);
        this.choseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_choseBtn,this);
        this.chosecity.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_chosecity,this)
        
    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_backBtn,this);
        this.choseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_choseBtn,this);
        this.chosecity.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_chosecity,this)

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }

    private initUI(): void {
        let showDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
        let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
        NetManager.ins.showLog(this.showExposure);
        let choseDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        let choseDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.choseExposure = Buried.createExposure(choseDpmOut, choseDcmOut);
        NetManager.ins.showLog(this.choseExposure);
        
        let sureDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let sureDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.sureExposure = Buried.createExposure(sureDpmOut, sureDcmOut);
        NetManager.ins.showLog(this.sureExposure);
        
        PanelCtrl.instance.btnAni(this.choseBtn);

        this.cityname.touchEnabled = false;
        if(this.mdata){
            console.log(this.mdata)
            if(this.mdata.shiname){
                let tempArr = [];
                tempArr = this.mdata.shiname.split('市');
                let newStr = tempArr.join('');
                this.cityname.text = this.mdata.shengname + newStr
            }else{
                this.cityname.text = this.mdata.shengname
            }
            let shengcode = this.mdata.adcode.substring(0,2)
            if( shengcode == 11){
                //北京
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/北京.png";
            }else if( shengcode == 12){
                //天津
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/天津.png";
            }else if( shengcode == 13){
                //河北
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/河北.png";
            }else if( shengcode == 14){
                //山西
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/山西.png";
            }else if( shengcode == 15){
                //内蒙古
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/内蒙古.png";
            }else if( shengcode == 21){
                //辽宁
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/辽宁.png";
            }else if( shengcode == 22){
                //吉林
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/吉林.png";
            }else if( shengcode == 23){
                //黑龙江
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/黑龙江.png";
            }else if( shengcode == 31){
                //上海
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/上海.png";
            }else if( shengcode == 32){
                //江苏
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/江苏.png";
            }else if( shengcode == 33){
                //浙江
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/浙江.png";
            }else if( shengcode == 34){
                //安徽
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/安徽.png";
            }else if( shengcode == 35){
                //福建
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/福建.png";
            }else if( shengcode == 36){
                //江西
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/江西.png";
            }else if( shengcode == 37){
                //山东
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/山东.png";
            }else if( shengcode == 41){
                //河南
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/河南.png";
            }else if( shengcode == 42){
                //湖北
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/湖北.png";
            }else if( shengcode == 43){
                //湖南
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/湖南.png";
            }else if( shengcode == 44){
                //广东
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/广东.png";
            }else if( shengcode == 45){
                //广西
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/广西.png";
            }else if( shengcode == 46){
                //海南
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/海南.png";
            }else if( shengcode == 50){
                //重庆
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/重庆.png";
            }else if( shengcode == 51){
                //四川
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/四川.png";
            }else if( shengcode == 52){
                //贵州
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/贵州.png";
            }else if( shengcode == 53){
                //云南
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/云南.png";
            }else if( shengcode == 54){
                //西藏
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/西藏.png";
            }else if( shengcode == 61){
                //陕西
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/陕西.png";
            }else if( shengcode == 62){
                //甘肃
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/甘肃.png";
            }else if( shengcode == 63){
                //青海
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/青海.png";
            }else if( shengcode == 64){
                //宁夏
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/宁夏.png";
            }else if( shengcode == 65){
                //新疆
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/新疆.png";
            }else if( shengcode == 71){
                //台湾
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/台湾.png";
            }else if( shengcode == 81){
                //香港
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/香港.png";
            }else if( shengcode == 82){
                //澳门
                this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/澳门.png";
            }
            
        }else{
            this.cityImg.source = "https://yun.duiba.com.cn/db_games/dljx/北京.png";
            this.cityname.text = "北京"
        }
    }

    onTap_backBtn(){
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);

    }
 
    onTap_choseBtn(){
        NetManager.ins.clickLog(this.sureExposure);
        PanelCtrl.instance.btnDelay(this.choseBtn)
        let data = {}
        if(this.mdata){
            this.adcode = this.mdata.adcode;
            this.province = this.mdata.shengname
            if(this.mdata.shiname){
                this.city=this.mdata.shiname
            }else{
                this.city = this.mdata.shengname
            }
        }else{
            this.adcode = 110000;
            this.province = "北京"
            this.city = "北京";
        }
        data = {adcode:this.adcode,province:this.province,city:this.city}

        PanelCtrl.instance.show(ModuleTypes.CHOSECITY_PANEL,data)

    }

    onTap_chosecity(){
        NetManager.ins.clickLog(this.choseExposure);
        PanelCtrl.instance.btnDelay(this.chosecity)
        NetPromise.ins.adList()
        .then(()=>{
            let data = DataManager.ins.getData(NetName.adList).data
            PanelCtrl.instance.show(ModuleTypes.PLACE_PANEL,data)
        })
        .catch(()=>{
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL);
        })

    }
}