import Scene from "../views/Scene";
import { MapComponent } from "../components/mapComponent";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetPromise } from "../NetPromise";
import ChoseCityPanel from "../choseScene/ChoseCityPanel";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class ShareScene extends Scene {


    public bg:eui.Group;
    public backBtn:eui.Button;
    public shareBtn:eui.Button;
    public prizeBtn:eui.Button;
    public mapGroup:eui.Group;
    public lab:eui.Label;
    

    private showExposure:any;
    private shareExposure:any;
    private share2Exposure:any;
    private prizeExposure:any;
    private mdata:any;

    public get skinKey() { return 'ShareScene' }
    public get groupName() { return 'share_scene' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_backBtn,this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_prizeBtn,this);
    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_backBtn,this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_prizeBtn,this);

        this.mapGroup.removeChild(this.map);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;


        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map;
    private initUI(): void {
        let showDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
        NetManager.ins.showLog(this.showExposure);
        let shareDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        let shareDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.shareExposure = Buried.createExposure(shareDpmOut, shareDcmOut);
        
        let prizeDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let prizeDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.prizeExposure = Buried.createExposure(prizeDpmOut, prizeDcmOut);
        

        let share2DpmOut = Buried.connectDpm(110, 18, 1); // 点击埋点   
        let share2DcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.share2Exposure = Buried.createExposure(share2DpmOut, share2DcmOut);

        PanelCtrl.instance.btnAni(this.shareBtn);
        PanelCtrl.instance.btnAni(this.prizeBtn);
        this.map=new MapComponent();
        this.mapGroup.addChild(this.map);
        if(NetPromise.ins.catchAdcode){
           // setTimeout(()=>{
                this.map.showPoint(NetPromise.ins.catchAdcode)
           // },500)
            NetPromise.ins.catchAdcode=null;
        }
        //中间地图信息待定（不是我做啦啦啦啦啦）
        if(this.mdata){
            if(this.mdata.total){
                if(this.mdata.total == 0){
                    this.prizeBtn.visible = true;
                    NetManager.ins.showLog(this.prizeExposure);
                    NetManager.ins.showLog(this.shareExposure);
        
                    
                }else{
                    this.prizeBtn.visible = false;
                    NetManager.ins.showLog(this.share2Exposure);
                }
            }else{
                this.prizeBtn.visible = true;
                NetManager.ins.showLog(this.prizeExposure);
                NetManager.ins.showLog(this.shareExposure);
                
            }
        }else{
            this.prizeBtn.visible = true;
            NetManager.ins.showLog(this.prizeExposure);
            NetManager.ins.showLog(this.shareExposure);
            
        }
        this.lab.alpha = 0;
        egret.Tween.get(this.lab)
        .set({alpha:0,y:600})
        .to({alpha:1,y:640},500)
        
        
    } 

    onTap_backBtn(){
        let data;
        if(ChoseCityPanel.instance){
            data = ChoseCityPanel.instance.adcodedata
        }else{
            data = DataManager.ins.getData(NetName.joinInfo).data;
        }
        
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE,data);
    }
    onTap_shareBtn(){
        if(this.mdata){
            if(this.mdata.total == 1){
                NetManager.ins.clickLog(this.share2Exposure);
            }else{
                NetManager.ins.clickLog(this.shareExposure);
            }
        }else{
            NetManager.ins.clickLog(this.shareExposure);
        }
        PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL);
    }
    onTap_prizeBtn(){
        NetManager.ins.clickLog(this.prizeExposure);
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        NetPromise.ins.getPrize()
        .then(()=>{
            this.prizeBtn.visible = false;
            let data = DataManager.ins.getData(NetName.getPrize).data;
            if(data){
                PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL,data);
            }else{
                PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
            }
            
        })
        .catch(()=>{
            
            // PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
        })
    }
}