import Scene from "../views/Scene";
import { MapComponent } from "../components/mapComponent";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetPromise } from "../NetPromise";
import ChoseCityPanel from "../choseScene/ChoseCityPanel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";

export default class ShareOutScene extends Scene {


    public mapGroup:eui.Group;
    public shareBtn:eui.Button;

    private mdata:any;
    private showExposure:any;
    private shareExposure:any;
    public get skinKey() { return 'ShareOutScene' }
    public get groupName() { return 'share_scene' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);
    }

    removeEvents() {
        super.removeEvents();
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_shareBtn,this);

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
 
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map;
    private initUI(): void {
        let showDpmOut = Buried.connectDpm(110, 14, 1); // 点击埋点   
        let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
        NetManager.ins.showLog(this.showExposure);
        let shareDpmOut = Buried.connectDpm(110, 15, 1); // 点击埋点   
        let shareDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.shareExposure = Buried.createExposure(shareDpmOut, shareDcmOut);
        NetManager.ins.showLog(this.shareExposure);
        

        this.map=new MapComponent();
        this.mapGroup.addChild(this.map);
        //中间地图信息待定（不是我做啦啦啦啦啦）
        PanelCtrl.instance.btnAni(this.shareBtn);
        
        
    } 

    onTap_shareBtn(){
        //唤端 下载链接
        NetManager.ins.clickLog(this.shareExposure);
        // setTimeout(()=>{
            window.location.href = "http://go.citicbank.com/xyqd-01";
        // },500)
        
    }
    
}