import Scene from "../views/Scene";
import { MapComponent } from "../components/mapComponent";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetPromise } from "../NetPromise";
import ChoseCityPanel from "../choseScene/ChoseCityPanel";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class BeforeShareScene extends Scene {

    public pageList:eui.Scroller;
    public goBtn:eui.Button;

    private mdata:any;
    private playExposure:any;
    private showExposure:any;

    public get skinKey() { return 'BeforeShareScene' }
    public get groupName() { return 'beforeshare_scene' }

    constructor(data?) {
        super(data);
        this.mdata = data;
    }

    initEvents() {
        // this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.goBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_goBtn,this);
    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        // this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        // this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        // this.timer.stop();//停止倒计时

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
       
        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        //this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        // this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.showAct();
        this.initUI();
    }
    map;
    private initUI(): void {
        let playDpmOut = Buried.connectDpm(110, 20, 1); // 点击埋点   
        let playDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.playExposure = Buried.createExposure(playDpmOut, playDcmOut);
        NetManager.ins.showLog(this.playExposure);

        let showDpmOut = Buried.connectDpm(110, 21, 1); // 点击埋点   
        let showDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.showExposure = Buried.createExposure(showDpmOut, showDcmOut);
        NetManager.ins.showLog(this.showExposure);
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.pageList.height = stageHeight;

        PanelCtrl.instance.btnAni(this.goBtn);
    } 

    onTap_goBtn(){
        NetManager.ins.clickLog(this.playExposure);
        window.location.href = "http://go.citicbank.com/xyqd-01";
    }
    
}