import { IStatusData } from './IStatusData';
import { Data } from "../../Data";

export class GetInfoData extends Data {
    /**
     * 用户ID
     */
    public consumerId: number;
    /**
     * 积分
     */
    public credits: number;

    /**
     * 累计成绩
     */
    public totalScore: number;

    /**
     * 最佳成绩
     */
    public maxScore: number;

    /**
     * 最佳成绩产生时间
     */
    public maxScoreTime: string;

    /**
     * 排名
     */
    public rank: number;

    /**
     * 百分比排名
     */
    public percentage: number;

    /**
     * 游戏状态
     */
    public token: string;

    public uid: string;

    /**
     * 
     */
    public status: IStatusData;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        let data;
        if (result.data) {
            if (result.data.rsp) {
                data = result.data.rsp;
            } else {
                data = result.data;
            }
        }
        this.consumerId = data.consumerId;
        this.credits = data.credits;
        this.totalScore = data.totalScore;
        this.maxScore = data.maxScore;
        this.maxScoreTime = data.maxScoreTime;
        this.rank = data.rank;
        this.uid = data.uid;
        this.percentage = data.percentage || 0;
        if (data.token) {
            this.token = window['resolve'](data.token);
        }
        this.status = data.status;
    }
}