"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var FoodItem = (function (_super) {
    __extends(FoodItem, _super);
    /**
     * @param id 食物id
     * @param count 食物数量
     * @param pos 显示位置
     */
    function FoodItem(id, count, pos, callBack) {
        var _this = _super.call(this) || this;
        _this.skinName = 'resource/skins/component/FoodComponent.exml';
        _this.fcount = count;
        _this.pos = pos;
        _this.fid = id;
        _this.clickCallBack = callBack;
        _this.addEventListener(egret.Event.COMPLETE, _this.onSkinComplete, _this);
        if (_this.skin) {
            _this.onSkinComplete();
        }
        return _this;
    }
    FoodItem.prototype.onSkinComplete = function () {
        this.foodNumLb.text = this.fcount + 'g';
        this.act.items[0].props = { loop: true };
        this.foodNumLb.touchEnabled = false;
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick, this);
    };
    FoodItem.prototype.removeEvent = function () {
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick, this);
    };
    FoodItem.prototype.onClick = function () {
        if (this.clickCallBack) {
            this.clickCallBack(this);
        }
    };
    FoodItem.prototype.playAct = function (start) {
        if (start === void 0) { start = 0; }
        this.act.play(start);
    };
    FoodItem.prototype.stopAct = function () {
        this.act.stop();
    };
    return FoodItem;
}(eui.Component));
exports.FoodItem = FoodItem;
__reflect(FoodItem.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/mainScene/FoodItem\".FoodItem");
//# sourceMappingURL=FoodItem.js.map