import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import TaskItem from './TaskItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { NetBuried } from '../NetBuried';

export default class StartScene extends Scene {

    public scroller_body:eui.Scroller;
    public bg:eui.Image;

    

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        // this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        // this.detailBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        // this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        // this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
    }

    removeEvents() {
        super.removeEvents();
        // this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        // this.detailBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        // this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        // this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
        clearInterval(this.adTime)
    }

    onTap_recordBtn(){
        if (DataManager.ins.getData(NetName.detailDo).data.beginTime > new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "beginActGroup" });
            this.enabled=true;
            return;
        }
        //PanelCtrl.instance.btnDelay(this.recordBtn);
        window.location.href=window["recordUrl"];
    }

    onTap_ruleBtn() {
        if (DataManager.ins.getData(NetName.detailDo).data.beginTime > new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "beginActGroup" });
            this.enabled=true;
            return;
        }
        let ruleData = `1、活动时间：2019年12月28日-2020年1月3日

2、活动期间，每位用户每天仅有一次挑战机会，完成“每日分享”可额外获得一次挑战次数。挑战机会当日有效，隔日作废。

3、游戏闯关后，将有机会获得口红大奖、红包等好礼，100%中奖！

4、完成“签约快捷支付功能”、“签约手机号转账”任务，有机会获得精美奖品！

5、口红大奖及大牌券等好礼的兑换方式及使用规则可至“我的奖品”中进行查看。

6、红包金额可至活动页面右侧“红包”处进行查看，红包需于活动结束后5个工作日内兑换完成。兑换的奖励于7个工作日后至民生银行App-生活圈-乐享优品-个人中心-代金券查看并使用。

7、本次活动最终解释权归中国民生银行上海分行所有。`
        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "ruleGroup", ruleData: ruleData })
    }

    onTap_detailBtn() {
        this.enabled = false;
        if (DataManager.ins.getData(NetName.detailDo).data.beginTime > new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "beginActGroup" });
            this.enabled=true;
            return;
        }
        NetPromise.ins.detailDo()
            .then(() => {
                this.enabled = true;
                SceneCtrl.instance.change(ModuleTypes.RED_SCENE)
            })
            .catch(() => {
                this.enabled = true;
            })
    }

    onTap_startBtn() {
      //  PanelCtrl.instance.btnDelay(this.startBtn)
      this.enabled=false;
        NetBuried.ins.clickLog(2)
        if(!NetPromise.ins.not_login){
            if (window['requirelogin']) {
                window['requirelogin']();
                this.enabled=true;
                return;
            }
            this.enabled=true;
            return
        }

        if (DataManager.ins.getData(NetName.detailDo).data.beginTime > new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "beginActGroup" });
            this.enabled=true;
            return;
        }

        if (DataManager.ins.getData(NetName.detailDo).data.endTime <= new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "overActGroup" });
            this.enabled=true;
            return;
        }

       

        

        // if(!window["isShanghai"]){
        //     NetPromise.ins.showToast("仅上海地区用户可参与活动哦~")
        //     this.enabled=true;
        //     if(!localStorage.duibadev){
        //         return
        //     }
        // }
        
        if(DataManager.ins.getData(NetName.times).data.times<=0){
            if(DataManager.ins.getData(NetName.times).data.qualification){
                console.log("分享增加次数弹窗")
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"tipsShareGroup"})
            }else{
                if(!this.isLastDay){
                    PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"noTimesGroup"})
                }else{
                    PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"noTimesLastDayGroup"})
                }
                console.log("次数已用完弹窗")
            }
            this.enabled=true;
            return;
        }

        NetPromise.ins.join2recordDo()
        .then(()=>{
            this.enabled=true;
            const isfirst = egret.localStorage.getItem('showGuide');
            if (!isfirst) {
                egret.localStorage.setItem('showGuide', 'true');
                PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
            } else {
                SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
            }
        })
        .catch(()=>{
            this.enabled=true;
        })
    }

    adTime

    isLastDay=false;

    protected onSkinComplete(): void {
        super.onSkinComplete();
      //  this.isLastDay=false;
        // this.mainbg.texture = this.bgtexture;
        // let stageHeight = 750 / window.innerWidth * window.innerHeight;
        // this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

    }

    animation() {
        this["disc_loop"].play(0)
        this["disc_loop"].items.forEach((item) => {
            item.tween.loop = true;
        })
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)

    }

    private initUI(): void {

    }
    private canStart: boolean;

}