import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import KhItem from './KhItem';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
export default class SelectKhPanel extends Panel {

    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public bodyScroller: eui.Scroller;
    public list: eui.List;
    public KhTipsText: eui.Label;



    private mdata: any;
    private scene: any;

    public get skinKey() { return 'SelectKhPanel' }
    public get groupName() { return 'selectkh_panel' }

    maxSelect = 0

    constructor(data: any) {
        super(data);
        this.mdata = data;

        this.maxSelect = this.mdata.maxSelect;
    }

    khData

    arrData

    onSkinComplete(): void {
        super.onSkinComplete();
        console.log(window["kh_data"])

        this.KhTipsText.text=`【请选择${this.mdata.maxSelect}支心仪的口红，确定后不可更改】`

        var tlayout = new eui.TileLayout();
        tlayout.horizontalGap = 0;
        tlayout.verticalGap = 0;
        tlayout.requestedColumnCount = 3;
        this.list.layout = tlayout;

        this.khData = window["kh_data"]
        for (let i = 0; i < this.khData.length; i++) {
            this.khData[i].select = false;
            this.khData[i].index = i;
        }
        this.list.itemRenderer = KhItem;
        this.arrData = new eui.ArrayCollection(this.khData);
        this.list.dataProvider = this.arrData;
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        GDispatcher.addEvent("updateKhList", this.updateKhList, this)
    }


    selectsIdList = []

    updateKhList(index, select) {
        this.khData[index].select = select;
        this.arrData.replaceAll(this.khData);

        this.selectsIdList = []
        for (let i = 0; i < this.khData.length; i++) {
            if (this.khData[i].select) {
                this.selectsIdList.push(this.khData[i].id)
            }
        }

        if(this.selectsIdList.length<this.maxSelect){
            this.sureBtn.enabled=false;
        }else{
            this.sureBtn.enabled=true;
        }
        console.log(this.selectsIdList.join())
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        GDispatcher.removeEvent("updateKhList", this.updateKhList, this)
    }

    onTap_closeBtn() {
        this.onTouchTap()
    }
}