import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class SelectKhPanel extends Panel {

    public panelGroup:eui.Group;
    public closeBtn:eui.Button;
    public sureBtn:eui.Button;
    public list:eui.List;    

    private mdata: any;
    private scene: any;

    public get skinKey() { return 'SelectKhPanel' }
    public get groupName() { return 'selectkh_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        var tlayout =new eui.TileLayout();
        tlayout.horizontalGap=0;
        tlayout.verticalGap=0;
        tlayout.requestedColumnCount=1000;
        this.list.layout=tlayout;
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }


    onTap_closeBtn() {
       this.onTouchTap()
    }
}