import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetPromise } from '../NetPromise';
export default class NoPrizePanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;
    public msgImg: eui.Image;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'NoPrizePanel' }
    public get groupName() { return 'noprize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        // 端内 再来一次 埋点
        let againDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let againDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let againExposure = Buried.createExposure(againDpmOut, againDcmOut);

        NetManager.ins.showLog(againExposure);
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_againBtn() {
       this.onTap_closeBtn()
    }

    onTap_closeBtn() {
        this.onTouchTap()
        NetPromise.ins.gotoIndex()
    }
}