import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class OverPanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public titleImg: eui.Image;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'Over' }
    public get groupName() { return 'over_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        //再来一次点击埋点
        let restartDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let restartDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let restartExposure = Buried.createExposure(restartDpmOut, restartDcmOut);

        NetManager.ins.showLog(restartExposure);
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }


    onTap_closeBtn() {
        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        if (this.isMPBank()) {
            // 端内
            window.location.href = `${window['appIndexLink']}`
        } else {
            // 端外
            window.location.href = `${window['outIndexLink']}`
        }

    }

    // 重新开始游戏
    onTap_againBtn() {
        this.restart();
    }

    restart() {
        PanelCtrl.instance.btnDelay(this.againBtn);

        // if (!this.scene.canStart) return;

        this.scene.isOver = false;

        //再来一次点击埋点
        let restartDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let restartDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let restartExposure = Buried.createExposure(restartDpmOut, restartDcmOut);

        NetManager.ins.clickLog(restartExposure);

        if (DataManager.ins.getInfoData.status.code == 3) {
            // 参与次数已用完
            if (this.isMPBank()) {
                // 端内
                PanelCtrl.instance.showMsg('okBtn', 6, null, null, () => {
                    window.location.href = `${window['appIndexLink']}`
                }, () => {
                    window.location.href = `${window['appIndexLink']}`
                });
            } else {
                // 端外
                PanelCtrl.instance.show(ModuleTypes.OUTNOTIMES_PANEL)
            }
            return;
        } else if (DataManager.ins.getInfoData.status.code == 2) {
            // 积分不足
            if (this.isMPBank()) {
                // 端内
                PanelCtrl.instance.showMsg('okBtn', 6, null, null, () => {
                    window.location.href = `${window['appIndexLink']}`
                }, () => {
                    window.location.href = `${window['appIndexLink']}`
                });
            } else {
                // 端外
                PanelCtrl.instance.show(ModuleTypes.OUTNOTIMES_PANEL)
            }
            return;
        } else if (DataManager.ins.getInfoData.status.code == 1) {
            // 未登录
            PanelCtrl.instance.showMsg('loginBtn', 2, null, null, function () {

            });
            return;
        } else {
            Loading.instace.show();
            NetManager.ins.doStart(function (success: boolean) {
                if (success) {
                    NetManager.ins.getStartStatus(
                        (data) => {
                            console.log('data轮询失败=' + data);
                            Loading.instace.hide();
                            if (data == 'pollingFaild' || !data) {//统一处理异常？？？？？？？
                                PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试~');
                                // Loading.instace.show();
                                return
                            } else {
                                //开始游戏
                                // PanelCtrl.instance.removeImmediately();
                                this.scene.gPlayModel.datapash();
                                this.scene.currLevel = 0;
                                this.scene.isRevived = false;
                                this.scene.revive();
                                this.hidePanel();
                                // PanelCtrl.instance.isLoseCoin = true;
                                // this.hideLevelTitleAct();
                            }
                        },
                        DataManager.ins.doStartData.ticketId,
                        () => { return DataManager.ins.getStartStatusData.code == 0; },
                        10);
                } else {
                    Loading.instace.hide();
                    console.log('dostart失败');
                    //统一处理异常？？？？？？？
                    PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试！');
                }
            }.bind(this), false);
        }
    }

    private isMPBank() {
        var ua = navigator.userAgent;
        // var ua = 'MPBank'
        if (ua.indexOf('MPBank') > -1)
            return true;
        else
            return false;
    }
}